/***
 *  This file is part of Clutter-Gesture.
 *
 *  Copyright 2009 (c) Intel Corp.
 *  Author: Long Bu    (long.bu@intel.com)
 *
 *  Clutter-Gesture is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation; either version 2.1 of the License,
 *  or (at your option) any later version.
 *
 *  Clutter-Gesture is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with ClutterGesture; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 *  USA.
 ***/
/*
 * Copyrigth (c) 2009 Intel
 * Author: Long Bu long.bu@intel.com
 */

#ifndef __clutter_gesture_h__
#define __clutter_gesture_h__

#include "gesture-events.h"

typedef struct _ClutterGesture ClutterGesture;
typedef struct _ClutterGestureClass ClutterGestureClass;
typedef struct _ClutterGesturePrivate ClutterGesturePrivate;

G_BEGIN_DECLS

#define CLUTTER_TYPE_GESTURE            (clutter_gesture_get_type ())
#define CLUTTER_GESTURE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLUTTER_TYPE_GESTURE, ClutterGesture))
#define CLUTTER_PAGE_GESTURE(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), CLUTTER_TYPE_GESTURE, ClutterGestureClass))
#define IS_CLUTTER_GESTURE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLUTTER_TYPE_GESTURE))
#define IS_CLUTTER_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLUTTER_TYPE_GESTURE))
#define CLUTTEER_GESTURE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), CLUTTER_TYPE_GESTURE, ClutterGestureClass))

GType clutter_gesture_get_type (void) G_GNUC_CONST;

struct _ClutterGesture
{
  /*< private >*/
  GObject parent;

  ClutterGesturePrivate *priv;
};

struct _ClutterGestureClass
{
  /*< private >*/
  GObjectClass parent_class;

  /*< public >*/
  gboolean (* gesture_pinch_event) (ClutterGesture           *gesture,
                                     ClutterGesturePinchEvent *event);
  gboolean (* gesture_rotate_event) (ClutterGesture            *gesture,
                                     ClutterGestureRotateEvent *event);
  gboolean (* gesture_slide_event) (ClutterGesture           *gesture,
                                    ClutterGestureSlideEvent *event);
  gboolean (* gesture_window_event) (ClutterGesture            *gesture,
                                     ClutterGestureWindowEvent *event);
  gboolean (* gesture_any_event) (ClutterGesture      *gesture,
                                  ClutterGestureEvent *event);
};

ClutterGesture *clutter_gesture_new (ClutterActor *actor);
gboolean
clutter_gesture_set_gesture_mask(ClutterGesture *gesture,
                                 ClutterActor *actor,
                                 gint mask);

#define GESTURE_MASK_SLIDE  (1<<0)
#define GESTURE_MASK_PINCH  (1<<1)
#define GESTURE_MASK_ROTATE  (1<<2)
#define GESTURE_MASK_WINDOW  (1<<3)

G_END_DECLS

#endif
