<?xml version="1.0"?>
<api version="1.0">
	<namespace name="Ctk">
		<function name="CheckGLError" symbol="CheckGLError">
			<return-type type="gint"/>
			<parameters>
				<parameter name="glCall" type="gchar*"/>
				<parameter name="file" type="gchar*"/>
				<parameter name="line" type="gint"/>
			</parameters>
		</function>
		<function name="cleanup" symbol="ctk_cleanup">
			<return-type type="void"/>
		</function>
		<function name="create_opengl_texture_from_file" symbol="ctk_create_opengl_texture_from_file">
			<return-type type="guint"/>
			<parameters>
				<parameter name="filename" type="char*"/>
			</parameters>
		</function>
		<function name="create_opengl_texture_from_pixbuf" symbol="ctk_create_opengl_texture_from_pixbuf">
			<return-type type="guint"/>
			<parameters>
				<parameter name="pixbuf" type="GdkPixbuf*"/>
			</parameters>
		</function>
		<function name="delete_opengl_texture" symbol="ctk_delete_opengl_texture">
			<return-type type="void"/>
			<parameters>
				<parameter name="opengl_texture_id" type="guint"/>
			</parameters>
		</function>
		<function name="dnd_init" symbol="ctk_dnd_init">
			<return-type type="void"/>
			<parameters>
				<parameter name="widget" type="GtkWidget*"/>
				<parameter name="targets" type="GtkTargetEntry*"/>
				<parameter name="n_targets" type="gint"/>
			</parameters>
		</function>
		<function name="drag_dest_find_target" symbol="ctk_drag_dest_find_target">
			<return-type type="GdkAtom"/>
			<parameters>
				<parameter name="context" type="GdkDragContext*"/>
				<parameter name="target_list" type="GtkTargetList*"/>
			</parameters>
		</function>
		<function name="drag_dest_is_dest" symbol="ctk_drag_dest_is_dest">
			<return-type type="gboolean"/>
			<parameters>
				<parameter name="widget" type="CtkActor*"/>
			</parameters>
		</function>
		<function name="drag_dest_start" symbol="ctk_drag_dest_start">
			<return-type type="void"/>
			<parameters>
				<parameter name="widget" type="CtkActor*"/>
			</parameters>
		</function>
		<function name="drag_get_data" symbol="ctk_drag_get_data">
			<return-type type="void"/>
			<parameters>
				<parameter name="actor" type="CtkActor*"/>
				<parameter name="context" type="GdkDragContext*"/>
				<parameter name="target" type="GdkAtom"/>
				<parameter name="time_" type="guint32"/>
			</parameters>
		</function>
		<function name="em_to_pixel" symbol="ctk_em_to_pixel">
			<return-type type="gdouble"/>
			<parameters>
				<parameter name="em_value" type="gdouble"/>
			</parameters>
		</function>
		<function name="get_actor_screen_coord" symbol="ctk_get_actor_screen_coord">
			<return-type type="void"/>
			<parameters>
				<parameter name="actor" type="CtkActor*"/>
				<parameter name="x" type="gfloat*"/>
				<parameter name="y" type="gfloat*"/>
				<parameter name="width" type="gfloat*"/>
				<parameter name="height" type="gfloat*"/>
			</parameters>
		</function>
		<function name="init" symbol="ctk_init">
			<return-type type="void"/>
			<parameters>
				<parameter name="argc" type="gint*"/>
				<parameter name="argv" type="gchar***"/>
			</parameters>
		</function>
		<function name="init_after" symbol="ctk_init_after">
			<return-type type="void"/>
			<parameters>
				<parameter name="argc" type="gint*"/>
				<parameter name="argv" type="gchar***"/>
			</parameters>
		</function>
		<function name="pixel_to_em" symbol="ctk_pixel_to_em">
			<return-type type="gdouble"/>
			<parameters>
				<parameter name="pixel_value" type="gint"/>
			</parameters>
		</function>
		<function name="render_projected_polygon" symbol="ctk_render_projected_polygon">
			<return-type type="void"/>
			<parameters>
				<parameter name="V" type="CtkProjectedTextureVertex*"/>
				<parameter name="tex_mask_id" type="guint"/>
				<parameter name="window_w" type="gint"/>
				<parameter name="window_h" type="gint"/>
			</parameters>
		</function>
		<function name="render_projected_polygon_2Tex" symbol="ctk_render_projected_polygon_2Tex">
			<return-type type="void"/>
			<parameters>
				<parameter name="V" type="CtkProjectedTextureVertex*"/>
				<parameter name="tex_mask_id" type="guint"/>
				<parameter name="tex_id" type="guint"/>
				<parameter name="window_w" type="gint"/>
				<parameter name="window_h" type="gint"/>
			</parameters>
		</function>
		<function name="surface_blur" symbol="ctk_surface_blur">
			<return-type type="void"/>
			<parameters>
				<parameter name="surface" type="cairo_surface_t*"/>
				<parameter name="radius" type="guint"/>
			</parameters>
		</function>
		<callback name="CtkEffectPaintFunc">
			<return-type type="void"/>
			<parameters>
				<parameter name="actor" type="ClutterActor*"/>
			</parameters>
		</callback>
		<struct name="CtkBoxChild">
		</struct>
		<struct name="CtkProjectedTextureVertex">
			<field name="x" type="gfloat"/>
			<field name="y" type="gfloat"/>
			<field name="z" type="gfloat"/>
			<field name="w" type="gfloat"/>
			<field name="s" type="gfloat"/>
			<field name="t" type="gfloat"/>
			<field name="r" type="gfloat"/>
			<field name="q" type="gfloat"/>
			<field name="color" type="CoglColor"/>
		</struct>
		<boxed name="CtkPadding" type-name="CtkPadding" get-type="ctk_padding_get_type">
			<field name="top" type="gfloat"/>
			<field name="right" type="gfloat"/>
			<field name="bottom" type="gfloat"/>
			<field name="left" type="gfloat"/>
		</boxed>
		<boxed name="CtkRenderTarget" type-name="CtkRenderTarget" get-type="ctk_render_target_get_type">
			<method name="bind" symbol="ctk_render_target_bind">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="free" symbol="ctk_render_target_free">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_color_buffer_ogl_id" symbol="ctk_render_target_get_color_buffer_ogl_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_depth_buffer_ogl_id" symbol="ctk_render_target_get_depth_buffer_ogl_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_flags" symbol="ctk_render_target_get_flags">
				<return-type type="CtkRenderTargetFlags"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_frame_buffer_ogl_id" symbol="ctk_render_target_get_frame_buffer_ogl_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_height" symbol="ctk_render_target_get_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="get_size" symbol="ctk_render_target_get_size">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
					<parameter name="width" type="guint*"/>
					<parameter name="height" type="guint*"/>
				</parameters>
			</method>
			<method name="get_width" symbol="ctk_render_target_get_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_render_target_new">
				<return-type type="CtkRenderTarget*"/>
			</constructor>
			<constructor name="new_sized" symbol="ctk_render_target_new_sized">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="width" type="guint"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</constructor>
			<method name="resize" symbol="ctk_render_target_resize">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
					<parameter name="width" type="guint"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_flags" symbol="ctk_render_target_set_flags">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRenderTarget*"/>
					<parameter name="flags" type="CtkRenderTargetFlags"/>
				</parameters>
			</method>
			<method name="unbind" symbol="ctk_render_target_unbind">
				<return-type type="void"/>
			</method>
		</boxed>
		<enum name="CtkActorState" type-name="CtkActorState" get-type="ctk_actor_state_get_type">
			<member name="CTK_STATE_NORMAL" value="0"/>
			<member name="CTK_STATE_ACTIVE" value="1"/>
			<member name="CTK_STATE_PRELIGHT" value="2"/>
			<member name="CTK_STATE_SELECTED" value="3"/>
			<member name="CTK_STATE_INSENSITIVE" value="4"/>
			<member name="CTK_N_STATES" value="5"/>
		</enum>
		<enum name="CtkFocusDirection" type-name="CtkFocusDirection" get-type="ctk_focus_direction_get_type">
			<member name="CTK_FOCUS_DIR_NONE" value="0"/>
			<member name="CTK_FOCUS_DIR_NEXT" value="1"/>
			<member name="CTK_FOCUS_DIR_PREV" value="2"/>
			<member name="CTK_FOCUS_DIR_UP" value="3"/>
			<member name="CTK_FOCUS_DIR_RIGHT" value="4"/>
			<member name="CTK_FOCUS_DIR_DOWN" value="5"/>
			<member name="CTK_FOCUS_DIR_LEFT" value="6"/>
		</enum>
		<enum name="CtkFocusEventType" type-name="CtkFocusEventType" get-type="ctk_focus_event_type_get_type">
			<member name="CTK_FOCUS_EVENT_NONE" value="0"/>
			<member name="CTK_FOCUS_EVENT_DIRECTION" value="1"/>
			<member name="CTK_FOCUS_EVENT_ACTIVATE" value="2"/>
		</enum>
		<enum name="CtkImageType" type-name="CtkImageType" get-type="ctk_image_type_get_type">
			<member name="CTK_IMAGE_EMPTY" value="0"/>
			<member name="CTK_IMAGE_PIXBUF" value="1"/>
			<member name="CTK_IMAGE_STOCK" value="2"/>
			<member name="CTK_IMAGE_ICON_NAME" value="3"/>
			<member name="CTK_IMAGE_GICON" value="4"/>
			<member name="CTK_IMAGE_FILENAME" value="5"/>
		</enum>
		<enum name="CtkLayerRepeatMode" type-name="CtkLayerRepeatMode" get-type="ctk_layer_repeat_mode_get_type">
			<member name="CTK_LAYER_REPEAT_NONE" value="0"/>
			<member name="CTK_LAYER_REPEAT_X" value="1"/>
			<member name="CTK_LAYER_REPEAT_Y" value="2"/>
		</enum>
		<enum name="CtkOrientation" type-name="CtkOrientation" get-type="ctk_orientation_get_type">
			<member name="CTK_ORIENTATION_HORIZONTAL" value="0"/>
			<member name="CTK_ORIENTATION_VERTICAL" value="1"/>
		</enum>
		<enum name="CtkScrollbarType" type-name="CtkScrollbarType" get-type="ctk_scrollbar_type_get_type">
			<member name="CTK_SCROLLBAR_INSET" value="0"/>
			<member name="CTK_SCROLLBAR_OVERLAY" value="1"/>
			<member name="CTK_SCROLLBAR_HIDDEN" value="2"/>
		</enum>
		<flags name="CtkRenderTargetFlags" type-name="CtkRenderTargetFlags" get-type="ctk_render_target_flags_get_type">
			<member name="CTK_RENDER_TARGET_IN_USE" value="1"/>
			<member name="CTK_RENDER_TARGET_STACKED" value="2"/>
		</flags>
		<object name="CtkActor" parent="ClutterActor" type-name="CtkActor" get-type="ctk_actor_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
			</implements>
			<method name="add_effect" symbol="ctk_actor_add_effect">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="effect" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="get_background" symbol="ctk_actor_get_background">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_background_for_state" symbol="ctk_actor_get_background_for_state">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="state" type="CtkActorState"/>
				</parameters>
			</method>
			<method name="get_damaged" symbol="ctk_actor_get_damaged">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_default_direction" symbol="ctk_actor_get_default_direction">
				<return-type type="GtkTextDirection"/>
			</method>
			<method name="get_effects" symbol="ctk_actor_get_effects">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_effects_painting" symbol="ctk_actor_get_effects_painting">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_padding" symbol="ctk_actor_get_padding">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="padding" type="CtkPadding*"/>
				</parameters>
			</method>
			<method name="get_state" symbol="ctk_actor_get_state">
				<return-type type="CtkActorState"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_stored_allocation" symbol="ctk_actor_get_stored_allocation">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="box" type="ClutterActorBox*"/>
				</parameters>
			</method>
			<method name="get_tooltip_text" symbol="ctk_actor_get_tooltip_text">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="recurse_get_stored_allocation_box" symbol="ctk_actor_recurse_get_stored_allocation_box">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="box" type="ClutterActorBox*"/>
				</parameters>
			</method>
			<method name="remove_all_effects" symbol="ctk_actor_remove_all_effects">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="remove_effect" symbol="ctk_actor_remove_effect">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="effect" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="set_background" symbol="ctk_actor_set_background">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="bg" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_background_for_state" symbol="ctk_actor_set_background_for_state">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="state" type="CtkActorState"/>
					<parameter name="bg" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_damaged" symbol="ctk_actor_set_damaged">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="damaged" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_default_direction" symbol="ctk_actor_set_default_direction">
				<return-type type="void"/>
				<parameters>
					<parameter name="dir" type="GtkTextDirection"/>
				</parameters>
			</method>
			<method name="set_effects_painting" symbol="ctk_actor_set_effects_painting">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="painting" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_padding" symbol="ctk_actor_set_padding">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="padding" type="CtkPadding*"/>
				</parameters>
			</method>
			<method name="set_state" symbol="ctk_actor_set_state">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="state" type="CtkActorState"/>
				</parameters>
			</method>
			<method name="set_tooltip_text" symbol="ctk_actor_set_tooltip_text">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="self" type="gchar*"/>
				</parameters>
			</method>
			<property name="background" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="effects-painting" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="focused" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="padding" type="CtkPadding*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="state" type="CtkActorState" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="tooltip-text" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<signal name="child-focus-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="box" type="ClutterActorBox*"/>
				</parameters>
			</signal>
			<signal name="drag-begin" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
				</parameters>
			</signal>
			<signal name="drag-data-delete" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
				</parameters>
			</signal>
			<signal name="drag-data-get" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="data" type="GtkSelectionData*"/>
					<parameter name="info" type="guint"/>
					<parameter name="time_" type="guint"/>
				</parameters>
			</signal>
			<signal name="drag-data-received" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="x" type="gint"/>
					<parameter name="y" type="gint"/>
					<parameter name="data" type="GtkSelectionData*"/>
					<parameter name="info" type="guint"/>
					<parameter name="time_" type="guint"/>
				</parameters>
			</signal>
			<signal name="drag-drop" when="LAST">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="x" type="gint"/>
					<parameter name="y" type="gint"/>
					<parameter name="time_" type="guint"/>
				</parameters>
			</signal>
			<signal name="drag-end" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
				</parameters>
			</signal>
			<signal name="drag-failed" when="LAST">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="result" type="GtkDragResult"/>
				</parameters>
			</signal>
			<signal name="drag-leave" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="time_" type="guint"/>
				</parameters>
			</signal>
			<signal name="drag-motion" when="LAST">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="actor" type="CtkActor*"/>
					<parameter name="context" type="GdkDragContext*"/>
					<parameter name="x" type="gint"/>
					<parameter name="y" type="gint"/>
					<parameter name="time_" type="guint"/>
				</parameters>
			</signal>
		</object>
		<object name="CtkBin" parent="CtkActor" type-name="CtkBin" get-type="ctk_bin_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_child" symbol="ctk_bin_get_child">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="bin" type="CtkBin*"/>
				</parameters>
			</method>
		</object>
		<object name="CtkBox" parent="CtkActor" type-name="CtkBox" get-type="ctk_box_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_homogeneous" symbol="ctk_box_get_homogeneous">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
				</parameters>
			</method>
			<method name="get_orientation" symbol="ctk_box_get_orientation">
				<return-type type="CtkOrientation"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
				</parameters>
			</method>
			<method name="get_spacing" symbol="ctk_box_get_spacing">
				<return-type type="gint"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
				</parameters>
			</method>
			<method name="pack" symbol="ctk_box_pack">
				<return-type type="void"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
					<parameter name="child" type="ClutterActor*"/>
					<parameter name="expand" type="gboolean"/>
					<parameter name="fill" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_homogeneous" symbol="ctk_box_set_homogeneous">
				<return-type type="void"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
					<parameter name="homogeneous" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_orientation" symbol="ctk_box_set_orientation">
				<return-type type="void"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
					<parameter name="orient" type="CtkOrientation"/>
				</parameters>
			</method>
			<method name="set_spacing" symbol="ctk_box_set_spacing">
				<return-type type="void"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
					<parameter name="spacing" type="gint"/>
				</parameters>
			</method>
			<method name="sort_children" symbol="ctk_box_sort_children">
				<return-type type="void"/>
				<parameters>
					<parameter name="box" type="CtkBox*"/>
					<parameter name="func" type="GCompareFunc"/>
				</parameters>
			</method>
			<property name="homogeneous" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="orientation" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="spacing" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkButton" parent="CtkBin" type-name="CtkButton" get-type="ctk_button_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_image" symbol="ctk_button_get_image">
				<return-type type="CtkImage*"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
				</parameters>
			</method>
			<method name="get_label" symbol="ctk_button_get_label">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
				</parameters>
			</method>
			<method name="get_orientation" symbol="ctk_button_get_orientation">
				<return-type type="CtkOrientation"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
				</parameters>
			</method>
			<method name="get_text" symbol="ctk_button_get_text">
				<return-type type="CtkText*"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_button_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="orientation" type="CtkOrientation"/>
				</parameters>
			</constructor>
			<method name="set_image" symbol="ctk_button_set_image">
				<return-type type="void"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="set_label" symbol="ctk_button_set_label">
				<return-type type="void"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_orientation" symbol="ctk_button_set_orientation">
				<return-type type="void"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
					<parameter name="orient" type="CtkOrientation"/>
				</parameters>
			</method>
			<method name="set_text" symbol="ctk_button_set_text">
				<return-type type="void"/>
				<parameters>
					<parameter name="button" type="CtkButton*"/>
					<parameter name="text" type="CtkText*"/>
				</parameters>
			</method>
			<property name="image" type="CtkImage*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="label" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="orientation" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<signal name="clicked" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="CtkButton*"/>
				</parameters>
			</signal>
			<signal name="show-context-menu" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="CtkButton*"/>
					<parameter name="event_time" type="guint"/>
				</parameters>
			</signal>
		</object>
		<object name="CtkCheckMenuItem" parent="CtkMenuItem" type-name="CtkCheckMenuItem" get-type="ctk_check_menu_item_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_active" symbol="ctk_check_menu_item_get_active">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="menuitem" type="CtkCheckMenuItem*"/>
				</parameters>
			</method>
			<method name="get_inconsistent" symbol="ctk_check_menu_item_get_inconsistent">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="menuitem" type="CtkCheckMenuItem*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_check_menu_item_new">
				<return-type type="CtkCheckMenuItem*"/>
			</constructor>
			<constructor name="new_with_label" symbol="ctk_check_menu_item_new_with_label">
				<return-type type="CtkCheckMenuItem*"/>
				<parameters>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_active" symbol="ctk_check_menu_item_set_active">
				<return-type type="void"/>
				<parameters>
					<parameter name="menuitem" type="CtkCheckMenuItem*"/>
					<parameter name="is_active" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_inconsistent" symbol="ctk_check_menu_item_set_inconsistent">
				<return-type type="void"/>
				<parameters>
					<parameter name="menuitem" type="CtkCheckMenuItem*"/>
					<parameter name="setting" type="gboolean"/>
				</parameters>
			</method>
			<property name="active" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="inconsistent" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<signal name="toggled" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkCheckMenuItem*"/>
				</parameters>
			</signal>
		</object>
		<object name="CtkEffect" parent="GInitiallyUnowned" type-name="CtkEffect" get-type="ctk_effect_get_type">
			<method name="animate" symbol="ctk_effect_animate">
				<return-type type="ClutterAnimation*"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="mode" type="gulong"/>
					<parameter name="duration" type="guint"/>
					<parameter name="first_property_name" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_actor" symbol="ctk_effect_get_actor">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="get_animation" symbol="ctk_effect_get_animation">
				<return-type type="ClutterAnimation*"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="get_margin" symbol="ctk_effect_get_margin">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="get_opacity" symbol="ctk_effect_get_opacity">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="get_strength" symbol="ctk_effect_get_strength">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="is_effect_cache_dirty" symbol="ctk_effect_is_effect_cache_dirty">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
				</parameters>
			</method>
			<method name="paint" symbol="ctk_effect_paint">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="func" type="CtkEffectPaintFunc"/>
					<parameter name="is_last_effect" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_actor" symbol="ctk_effect_set_actor">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="actor" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_invalidate_effect_cache" symbol="ctk_effect_set_invalidate_effect_cache">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="dirty" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_margin" symbol="ctk_effect_set_margin">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="m" type="gint"/>
				</parameters>
			</method>
			<method name="set_opacity" symbol="ctk_effect_set_opacity">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="m" type="gfloat"/>
				</parameters>
			</method>
			<method name="set_strength" symbol="ctk_effect_set_strength">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffect*"/>
					<parameter name="strength" type="gint"/>
				</parameters>
			</method>
			<property name="actor" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="margin" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="opacity" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="strength" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<vfunc name="paint">
				<return-type type="void"/>
				<parameters>
					<parameter name="effect" type="CtkEffect*"/>
					<parameter name="func" type="CtkEffectPaintFunc"/>
					<parameter name="is_last_effect" type="gboolean"/>
				</parameters>
			</vfunc>
		</object>
		<object name="CtkEffectBlur" parent="CtkEffect" type-name="CtkEffectBlur" get-type="ctk_effect_blur_get_type">
			<method name="get_factor" symbol="ctk_effect_blur_get_factor">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="blur" type="CtkEffectBlur*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_effect_blur_new">
				<return-type type="CtkEffect*"/>
			</constructor>
			<method name="set_factor" symbol="ctk_effect_blur_set_factor">
				<return-type type="void"/>
				<parameters>
					<parameter name="blur" type="CtkEffectBlur*"/>
					<parameter name="factor" type="gfloat"/>
				</parameters>
			</method>
			<property name="factor" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkEffectCache" parent="CtkEffect" type-name="CtkEffectCache" get-type="ctk_effect_cache_get_type">
			<method name="invalidate_texture_cache" symbol="ctk_effect_cache_invalidate_texture_cache">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffectCache*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_effect_cache_new">
				<return-type type="CtkEffect*"/>
			</constructor>
			<method name="update_texture_cache" symbol="ctk_effect_cache_update_texture_cache">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffectCache*"/>
				</parameters>
			</method>
		</object>
		<object name="CtkEffectContext" parent="GObject" type-name="CtkEffectContext" get-type="ctk_effect_context_get_type">
			<method name="get_default_for_actor" symbol="ctk_effect_context_get_default_for_actor">
				<return-type type="CtkEffectContext*"/>
				<parameters>
					<parameter name="actor" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="get_default_for_stage" symbol="ctk_effect_context_get_default_for_stage">
				<return-type type="CtkEffectContext*"/>
				<parameters>
					<parameter name="stage" type="ClutterStage*"/>
				</parameters>
			</method>
			<method name="get_utility_render_target" symbol="ctk_effect_context_get_utility_render_target">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
				</parameters>
			</method>
			<method name="grab_render_target" symbol="ctk_effect_context_grab_render_target">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
				</parameters>
			</method>
			<method name="grab_render_target_for_actor" symbol="ctk_effect_context_grab_render_target_for_actor">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
					<parameter name="actor" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="grab_render_target_for_size" symbol="ctk_effect_context_grab_render_target_for_size">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
					<parameter name="width" type="guint"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="peek_render_target" symbol="ctk_effect_context_peek_render_target">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
				</parameters>
			</method>
			<method name="pop_render_target" symbol="ctk_effect_context_pop_render_target">
				<return-type type="CtkRenderTarget*"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
				</parameters>
			</method>
			<method name="push_render_target" symbol="ctk_effect_context_push_render_target">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
					<parameter name="target" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<method name="release_render_target" symbol="ctk_effect_context_release_render_target">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffectContext*"/>
					<parameter name="target" type="CtkRenderTarget*"/>
				</parameters>
			</method>
			<property name="stage" type="gpointer" readable="1" writable="1" construct="0" construct-only="1"/>
		</object>
		<object name="CtkEffectDropShadow" parent="CtkEffect" type-name="CtkEffectDropShadow" get-type="ctk_effect_drop_shadow_get_type">
			<method name="get_blur_factor" symbol="ctk_effect_drop_shadow_get_blur_factor">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
				</parameters>
			</method>
			<method name="get_offset_x" symbol="ctk_effect_drop_shadow_get_offset_x">
				<return-type type="gint"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
				</parameters>
			</method>
			<method name="get_offset_y" symbol="ctk_effect_drop_shadow_get_offset_y">
				<return-type type="gint"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_effect_drop_shadow_new">
				<return-type type="CtkEffectDropShadow*"/>
				<parameters>
					<parameter name="blurfactor" type="gfloat"/>
					<parameter name="offset_x" type="gint"/>
					<parameter name="offset_y" type="gint"/>
				</parameters>
			</constructor>
			<method name="set_blur_factor" symbol="ctk_effect_drop_shadow_set_blur_factor">
				<return-type type="void"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
					<parameter name="size" type="gfloat"/>
				</parameters>
			</method>
			<method name="set_offset_x" symbol="ctk_effect_drop_shadow_set_offset_x">
				<return-type type="void"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
					<parameter name="offset_x" type="gint"/>
				</parameters>
			</method>
			<method name="set_offset_y" symbol="ctk_effect_drop_shadow_set_offset_y">
				<return-type type="void"/>
				<parameters>
					<parameter name="drop_shadow" type="CtkEffectDropShadow*"/>
					<parameter name="offset_y" type="gint"/>
				</parameters>
			</method>
			<property name="blur-factor" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="offset-x" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="offset-y" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkEffectGlow" parent="CtkEffect" type-name="CtkEffectGlow" get-type="ctk_effect_glow_get_type">
			<method name="get_color" symbol="ctk_effect_glow_get_color">
				<return-type type="void"/>
				<parameters>
					<parameter name="glow" type="CtkEffectGlow*"/>
					<parameter name="color" type="ClutterColor*"/>
				</parameters>
			</method>
			<method name="get_factor" symbol="ctk_effect_glow_get_factor">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="glow" type="CtkEffectGlow*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_effect_glow_new">
				<return-type type="CtkEffect*"/>
			</constructor>
			<method name="set_background_texture" symbol="ctk_effect_glow_set_background_texture">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkEffectGlow*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_color" symbol="ctk_effect_glow_set_color">
				<return-type type="void"/>
				<parameters>
					<parameter name="glow" type="CtkEffectGlow*"/>
					<parameter name="c" type="ClutterColor*"/>
				</parameters>
			</method>
			<method name="set_factor" symbol="ctk_effect_glow_set_factor">
				<return-type type="void"/>
				<parameters>
					<parameter name="glow" type="CtkEffectGlow*"/>
					<parameter name="factor" type="gfloat"/>
				</parameters>
			</method>
			<property name="color" type="ClutterColor*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="factor" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkHBox" parent="CtkBox" type-name="CtkHBox" get-type="ctk_hbox_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<constructor name="new" symbol="ctk_hbox_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="spacing" type="guint"/>
				</parameters>
			</constructor>
		</object>
		<object name="CtkIconView" parent="CtkActor" type-name="CtkIconView" get-type="ctk_icon_view_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_n_cols" symbol="ctk_icon_view_get_n_cols">
				<return-type type="guint"/>
				<parameters>
					<parameter name="icon_view" type="CtkIconView*"/>
				</parameters>
			</method>
			<method name="get_n_rows" symbol="ctk_icon_view_get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="icon_view" type="CtkIconView*"/>
				</parameters>
			</method>
			<method name="get_spacing" symbol="ctk_icon_view_get_spacing">
				<return-type type="gint"/>
				<parameters>
					<parameter name="icon_view" type="CtkIconView*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_icon_view_new">
				<return-type type="ClutterActor*"/>
			</constructor>
			<method name="set_spacing" symbol="ctk_icon_view_set_spacing">
				<return-type type="void"/>
				<parameters>
					<parameter name="icon_view" type="CtkIconView*"/>
					<parameter name="spacing" type="gint"/>
				</parameters>
			</method>
			<property name="auto-fade-children" type="gboolean" readable="1" writable="1" construct="1" construct-only="0"/>
			<property name="n-cols" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="n-rows" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="spacing" type="gint" readable="1" writable="1" construct="1" construct-only="0"/>
		</object>
		<object name="CtkImage" parent="CtkActor" type-name="CtkImage" get-type="ctk_image_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
			</implements>
			<method name="get_filename" symbol="ctk_image_get_filename">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_gicon" symbol="ctk_image_get_gicon">
				<return-type type="GIcon*"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_icon_name" symbol="ctk_image_get_icon_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_image_storage_type" symbol="ctk_image_get_image_storage_type">
				<return-type type="CtkImageType"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_pixbuf" symbol="ctk_image_get_pixbuf">
				<return-type type="GdkPixbuf*"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_size" symbol="ctk_image_get_size">
				<return-type type="guint"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<method name="get_stock" symbol="ctk_image_get_stock">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_image_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
				</parameters>
			</constructor>
			<constructor name="new_from_filename" symbol="ctk_image_new_from_filename">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
					<parameter name="filename" type="gchar*"/>
				</parameters>
			</constructor>
			<constructor name="new_from_gicon" symbol="ctk_image_new_from_gicon">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
					<parameter name="icon" type="GIcon*"/>
				</parameters>
			</constructor>
			<constructor name="new_from_icon_name" symbol="ctk_image_new_from_icon_name">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
					<parameter name="icon_name" type="gchar*"/>
				</parameters>
			</constructor>
			<constructor name="new_from_pixbuf" symbol="ctk_image_new_from_pixbuf">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</constructor>
			<constructor name="new_from_stock" symbol="ctk_image_new_from_stock">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="size" type="guint"/>
					<parameter name="stock_id" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_from_filename" symbol="ctk_image_set_from_filename">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="filename" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_from_gicon" symbol="ctk_image_set_from_gicon">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="icon" type="GIcon*"/>
				</parameters>
			</method>
			<method name="set_from_icon_name" symbol="ctk_image_set_from_icon_name">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="icon_name" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_from_pixbuf" symbol="ctk_image_set_from_pixbuf">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_from_stock" symbol="ctk_image_set_from_stock">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="stock_id" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_size" symbol="ctk_image_set_size">
				<return-type type="void"/>
				<parameters>
					<parameter name="image" type="CtkImage*"/>
					<parameter name="size" type="guint"/>
				</parameters>
			</method>
			<property name="filename" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="gicon" type="GIcon*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="icon-name" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="pixbuf" type="GdkPixbuf*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="size" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="stock-id" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkImageMenuItem" parent="CtkMenuItem" type-name="CtkImageMenuItem" get-type="ctk_image_menu_item_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_image" symbol="ctk_image_menu_item_get_image">
				<return-type type="GdkPixbuf*"/>
				<parameters>
					<parameter name="menuitem" type="CtkImageMenuItem*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_image_menu_item_new">
				<return-type type="CtkImageMenuItem*"/>
			</constructor>
			<constructor name="new_with_label" symbol="ctk_image_menu_item_new_with_label">
				<return-type type="CtkImageMenuItem*"/>
				<parameters>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_image" symbol="ctk_image_menu_item_set_image">
				<return-type type="void"/>
				<parameters>
					<parameter name="menuitem" type="CtkImageMenuItem*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<property name="image" type="GdkPixbuf*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkLayer" parent="GObject" type-name="CtkLayer" get-type="ctk_layer_get_type">
			<method name="get_color" symbol="ctk_layer_get_color">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="color" type="ClutterColor*"/>
				</parameters>
			</method>
			<method name="get_enabled" symbol="ctk_layer_get_enabled">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_height" symbol="ctk_layer_get_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_image_id" symbol="ctk_layer_get_image_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_image_pixbuf" symbol="ctk_layer_get_image_pixbuf">
				<return-type type="GdkPixbuf*"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_image_repeat_mode" symbol="ctk_layer_get_image_repeat_mode">
				<return-type type="CtkLayerRepeatMode"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_mask_id" symbol="ctk_layer_get_mask_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_mask_pixbuf" symbol="ctk_layer_get_mask_pixbuf">
				<return-type type="GdkPixbuf*"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_mask_repeat_mode" symbol="ctk_layer_get_mask_repeat_mode">
				<return-type type="CtkLayerRepeatMode"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_opacity" symbol="ctk_layer_get_opacity">
				<return-type type="guint8"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="get_width" symbol="ctk_layer_get_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="is_valid" symbol="ctk_layer_is_valid">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_layer_new">
				<return-type type="CtkLayer*"/>
				<parameters>
					<parameter name="width" type="guint"/>
					<parameter name="height" type="guint"/>
					<parameter name="image_repeat" type="CtkLayerRepeatMode"/>
					<parameter name="mask_repeat" type="CtkLayerRepeatMode"/>
				</parameters>
			</constructor>
			<method name="set_color" symbol="ctk_layer_set_color">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="color" type="ClutterColor*"/>
				</parameters>
			</method>
			<method name="set_enabled" symbol="ctk_layer_set_enabled">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="enabled" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_height" symbol="ctk_layer_set_height">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_image_from_file" symbol="ctk_layer_set_image_from_file">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="filename" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_image_from_id" symbol="ctk_layer_set_image_from_id">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="id" type="guint"/>
				</parameters>
			</method>
			<method name="set_image_from_pixbuf" symbol="ctk_layer_set_image_from_pixbuf">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_image_from_surface" symbol="ctk_layer_set_image_from_surface">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="surface" type="cairo_surface_t*"/>
				</parameters>
			</method>
			<method name="set_image_pixbuf" symbol="ctk_layer_set_image_pixbuf">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_image_repeat_mode" symbol="ctk_layer_set_image_repeat_mode">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="repeat" type="CtkLayerRepeatMode"/>
				</parameters>
			</method>
			<method name="set_mask_from_file" symbol="ctk_layer_set_mask_from_file">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="filename" type="gchar*"/>
				</parameters>
			</method>
			<method name="set_mask_from_id" symbol="ctk_layer_set_mask_from_id">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="id" type="guint"/>
				</parameters>
			</method>
			<method name="set_mask_from_pixbuf" symbol="ctk_layer_set_mask_from_pixbuf">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_mask_from_surface" symbol="ctk_layer_set_mask_from_surface">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="surface" type="cairo_surface_t*"/>
				</parameters>
			</method>
			<method name="set_mask_pixbuf" symbol="ctk_layer_set_mask_pixbuf">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="pixbuf" type="GdkPixbuf*"/>
				</parameters>
			</method>
			<method name="set_mask_repeat_mode" symbol="ctk_layer_set_mask_repeat_mode">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="repeat" type="CtkLayerRepeatMode"/>
				</parameters>
			</method>
			<method name="set_opacity" symbol="ctk_layer_set_opacity">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="opacity" type="guint8"/>
				</parameters>
			</method>
			<method name="set_width" symbol="ctk_layer_set_width">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayer*"/>
					<parameter name="width" type="guint"/>
				</parameters>
			</method>
			<property name="color" type="ClutterColor*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="enabled" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="height" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="image-id" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="image-pixbuf" type="GdkPixbuf*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="image-repeat-mode" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="mask-id" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="mask-pixbuf" type="GdkPixbuf*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="mask-repeat-mode" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="opacity" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="valid" type="gboolean" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="width" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkLayerActor" parent="CtkActor" type-name="CtkLayerActor" get-type="ctk_layer_actor_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
			</implements>
			<method name="add_layer" symbol="ctk_layer_actor_add_layer">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
					<parameter name="layer" type="CtkLayer*"/>
				</parameters>
			</method>
			<method name="flatten" symbol="ctk_layer_actor_flatten">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
				</parameters>
			</method>
			<method name="get_height" symbol="ctk_layer_actor_get_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
				</parameters>
			</method>
			<method name="get_layer" symbol="ctk_layer_actor_get_layer">
				<return-type type="CtkLayer*"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
					<parameter name="index" type="guint"/>
				</parameters>
			</method>
			<method name="get_num_layers" symbol="ctk_layer_actor_get_num_layers">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
				</parameters>
			</method>
			<method name="get_width" symbol="ctk_layer_actor_get_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
				</parameters>
			</method>
			<method name="is_flattened" symbol="ctk_layer_actor_is_flattened">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_layer_actor_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="width" type="guint"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</constructor>
			<method name="set_height" symbol="ctk_layer_actor_set_height">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_width" symbol="ctk_layer_actor_set_width">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkLayerActor*"/>
					<parameter name="width" type="guint"/>
				</parameters>
			</method>
			<property name="flattened" type="gboolean" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="height" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="num-layers" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="width" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkMenu" parent="CtkActor" type-name="CtkMenu" get-type="ctk_menu_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="append" symbol="ctk_menu_append">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="item" type="ClutterActor*"/>
					<parameter name="is_special" type="gboolean"/>
				</parameters>
			</method>
			<method name="attach_to_actor" symbol="ctk_menu_attach_to_actor">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="actor" type="CtkActor*"/>
				</parameters>
			</method>
			<method name="get_attached_actor" symbol="ctk_menu_get_attached_actor">
				<return-type type="CtkActor*"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_background" symbol="ctk_menu_get_background">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_close_on_leave" symbol="ctk_menu_get_close_on_leave">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_framebuffer_background" symbol="ctk_menu_get_framebuffer_background">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_items" symbol="ctk_menu_get_items">
				<return-type type="GList*"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_num_items" symbol="ctk_menu_get_num_items">
				<return-type type="gint"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_spacing" symbol="ctk_menu_get_spacing">
				<return-type type="gint"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_special_item_height" symbol="ctk_menu_get_special_item_height">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_special_item_index" symbol="ctk_menu_get_special_item_index">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="get_special_item_y" symbol="ctk_menu_get_special_item_y">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="is_expandable" symbol="ctk_menu_is_expandable">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_menu_new">
				<return-type type="CtkMenu*"/>
			</constructor>
			<constructor name="new_with_background" symbol="ctk_menu_new_with_background">
				<return-type type="CtkMenu*"/>
				<parameters>
					<parameter name="background" type="ClutterActor*"/>
				</parameters>
			</constructor>
			<method name="prepend" symbol="ctk_menu_prepend">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="item" type="ClutterActor*"/>
					<parameter name="is_special" type="gboolean"/>
				</parameters>
			</method>
			<method name="refresh_background_texture" symbol="ctk_menu_refresh_background_texture">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="remove_all" symbol="ctk_menu_remove_all">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
				</parameters>
			</method>
			<method name="set_background" symbol="ctk_menu_set_background">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="background" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_close_on_leave" symbol="ctk_menu_set_close_on_leave">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
					<parameter name="value" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_color" symbol="ctk_menu_set_color">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="color" type="ClutterColor*"/>
				</parameters>
			</method>
			<method name="set_detect_clicks" symbol="ctk_menu_set_detect_clicks">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="value" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_is_expandable" symbol="ctk_menu_set_is_expandable">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenu*"/>
					<parameter name="b" type="gboolean"/>
				</parameters>
			</method>
			<method name="set_spacing" symbol="ctk_menu_set_spacing">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="spacing" type="gint"/>
				</parameters>
			</method>
			<method name="set_swallow_clicks" symbol="ctk_menu_set_swallow_clicks">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
					<parameter name="value" type="gboolean"/>
				</parameters>
			</method>
			<property name="background" type="ClutterActor*" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="close-on-leave" type="gboolean" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="num-items" type="gint" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="spacing" type="gint" readable="1" writable="1" construct="0" construct-only="0"/>
			<signal name="closed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="menu" type="CtkMenu*"/>
				</parameters>
			</signal>
		</object>
		<object name="CtkMenuExpandable" parent="CtkMenu" type-name="CtkMenuExpandable" get-type="ctk_menu_expandable_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="compute_style_textures" symbol="ctk_menu_expandable_compute_style_textures">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_anchor_height" symbol="ctk_menu_expandable_get_anchor_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_anchor_size_offset" symbol="ctk_menu_expandable_get_anchor_size_offset">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_anchor_width" symbol="ctk_menu_expandable_get_anchor_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_bg_fill_image_height" symbol="ctk_menu_expandable_get_bg_fill_image_height">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_bg_fill_image_id" symbol="ctk_menu_expandable_get_bg_fill_image_id">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_bg_fill_image_width" symbol="ctk_menu_expandable_get_bg_fill_image_width">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_content_padding" symbol="ctk_menu_expandable_get_content_padding">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_content_padding_left_right" symbol="ctk_menu_expandable_get_content_padding_left_right">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_corner_radius" symbol="ctk_menu_expandable_get_corner_radius">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_expansion_size_factor" symbol="ctk_menu_expandable_get_expansion_size_factor">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_padding" symbol="ctk_menu_expandable_get_padding">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<method name="get_transition_steps" symbol="ctk_menu_expandable_get_transition_steps">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_menu_expandable_new">
				<return-type type="CtkMenuExpandable*"/>
			</constructor>
			<method name="set_anchor_position" symbol="ctk_menu_expandable_set_anchor_position">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="x" type="gfloat"/>
					<parameter name="y" type="gfloat"/>
					<parameter name="tooltip_y_in_menu" type="gint"/>
				</parameters>
			</method>
			<method name="set_bg_fill_image_height" symbol="ctk_menu_expandable_set_bg_fill_image_height">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="height" type="guint"/>
				</parameters>
			</method>
			<method name="set_bg_fill_image_id" symbol="ctk_menu_expandable_set_bg_fill_image_id">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="image_id" type="guint"/>
				</parameters>
			</method>
			<method name="set_bg_fill_image_width" symbol="ctk_menu_expandable_set_bg_fill_image_width">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="width" type="guint"/>
				</parameters>
			</method>
			<method name="set_content_padding" symbol="ctk_menu_expandable_set_content_padding">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="padding" type="gint"/>
				</parameters>
			</method>
			<method name="set_content_padding_left_right" symbol="ctk_menu_expandable_set_content_padding_left_right">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="padding" type="gint"/>
				</parameters>
			</method>
			<method name="set_expansion_size_factor" symbol="ctk_menu_expandable_set_expansion_size_factor">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="factor" type="gfloat"/>
				</parameters>
			</method>
			<method name="set_full_textures" symbol="ctk_menu_expandable_set_full_textures">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="surf" type="cairo_surface_t*"/>
					<parameter name="mask_surf" type="cairo_surface_t*"/>
				</parameters>
			</method>
			<method name="set_padding" symbol="ctk_menu_expandable_set_padding">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="padding" type="gint"/>
				</parameters>
			</method>
			<method name="set_transition_textures" symbol="ctk_menu_expandable_set_transition_textures">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuExpandable*"/>
					<parameter name="index" type="int"/>
					<parameter name="surf" type="cairo_surface_t*"/>
					<parameter name="mask_surf" type="cairo_surface_t*"/>
				</parameters>
			</method>
			<property name="bg-fill-image-height" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="bg-fill-image-id" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="bg-fill-image-width" type="guint" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="expansion-size-factor" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkMenuItem" parent="CtkBin" type-name="CtkMenuItem" get-type="ctk_menu_item_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_label" symbol="ctk_menu_item_get_label">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="item" type="CtkMenuItem*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_menu_item_new">
				<return-type type="CtkMenuItem*"/>
			</constructor>
			<constructor name="new_with_label" symbol="ctk_menu_item_new_with_label">
				<return-type type="CtkMenuItem*"/>
				<parameters>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_label" symbol="ctk_menu_item_set_label">
				<return-type type="void"/>
				<parameters>
					<parameter name="item" type="CtkMenuItem*"/>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</method>
			<property name="label" type="char*" readable="1" writable="1" construct="1" construct-only="0"/>
			<signal name="activated" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkMenuItem*"/>
				</parameters>
			</signal>
		</object>
		<object name="CtkMenuSeperator" parent="CtkMenuItem" type-name="CtkMenuSeperator" get-type="ctk_menu_seperator_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<constructor name="new" symbol="ctk_menu_seperator_new">
				<return-type type="CtkMenuSeperator*"/>
			</constructor>
		</object>
		<object name="CtkRadioMenuItem" parent="CtkCheckMenuItem" type-name="CtkRadioMenuItem" get-type="ctk_radio_menu_item_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_group" symbol="ctk_radio_menu_item_get_group">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="menuitem" type="CtkRadioMenuItem*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_radio_menu_item_new">
				<return-type type="CtkRadioMenuItem*"/>
				<parameters>
					<parameter name="group" type="GSList*"/>
				</parameters>
			</constructor>
			<constructor name="new_with_label" symbol="ctk_radio_menu_item_new_with_label">
				<return-type type="CtkRadioMenuItem*"/>
				<parameters>
					<parameter name="group" type="GSList*"/>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_group" symbol="ctk_radio_menu_item_set_group">
				<return-type type="void"/>
				<parameters>
					<parameter name="menuitem" type="CtkRadioMenuItem*"/>
					<parameter name="group" type="GSList*"/>
				</parameters>
			</method>
			<property name="group" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<signal name="group-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkRadioMenuItem*"/>
				</parameters>
			</signal>
			<field name="group" type="GSList*"/>
		</object>
		<object name="CtkScrollView" parent="CtkBin" type-name="CtkScrollView" get-type="ctk_scroll_view_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="can_scroll" symbol="ctk_scroll_view_can_scroll">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
				</parameters>
			</method>
			<method name="get_bar_type" symbol="ctk_scroll_view_get_bar_type">
				<return-type type="CtkScrollbarType"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
				</parameters>
			</method>
			<method name="get_scroll_bar" symbol="ctk_scroll_view_get_scroll_bar">
				<return-type type="void"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
					<parameter name="trough" type="ClutterActor**"/>
					<parameter name="slider" type="ClutterActor**"/>
				</parameters>
			</method>
			<method name="get_value" symbol="ctk_scroll_view_get_value">
				<return-type type="gfloat"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_scroll_view_new">
				<return-type type="ClutterActor*"/>
			</constructor>
			<method name="scroll" symbol="ctk_scroll_view_scroll">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
					<parameter name="event" type="ClutterScrollEvent*"/>
				</parameters>
			</method>
			<method name="set_bar_type" symbol="ctk_scroll_view_set_bar_type">
				<return-type type="void"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
					<parameter name="type" type="CtkScrollbarType"/>
				</parameters>
			</method>
			<method name="set_scroll_bar" symbol="ctk_scroll_view_set_scroll_bar">
				<return-type type="void"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
					<parameter name="trough" type="ClutterActor*"/>
					<parameter name="slider" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_value" symbol="ctk_scroll_view_set_value">
				<return-type type="void"/>
				<parameters>
					<parameter name="view" type="CtkScrollView*"/>
					<parameter name="value" type="gfloat"/>
				</parameters>
			</method>
			<property name="scrollbar-type" type="CtkScrollbarType" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="value" type="gfloat" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkText" parent="ClutterText" type-name="CtkText" get-type="ctk_text_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
			</implements>
			<method name="get_alignment" symbol="ctk_text_get_alignment">
				<return-type type="PangoAlignment"/>
				<parameters>
					<parameter name="self" type="CtkText*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_text_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="text" type="gchar*"/>
				</parameters>
			</constructor>
			<method name="set_alignment" symbol="ctk_text_set_alignment">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkText*"/>
					<parameter name="alignment" type="PangoAlignment"/>
				</parameters>
			</method>
		</object>
		<object name="CtkTooltip" parent="CtkActor" type-name="CtkTooltip" get-type="ctk_tooltip_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
			</implements>
			<method name="get_actor" symbol="ctk_tooltip_get_actor">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
				</parameters>
			</method>
			<method name="get_label" symbol="ctk_tooltip_get_label">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
				</parameters>
			</method>
			<method name="hide" symbol="ctk_tooltip_hide">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="ctk_tooltip_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="actor" type="ClutterActor*"/>
				</parameters>
			</constructor>
			<method name="set_actor" symbol="ctk_tooltip_set_actor">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
					<parameter name="actor" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="set_label" symbol="ctk_tooltip_set_label">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
					<parameter name="label" type="gchar*"/>
				</parameters>
			</method>
			<method name="show" symbol="ctk_tooltip_show">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkTooltip*"/>
					<parameter name="x" type="gint"/>
					<parameter name="y" type="gint"/>
				</parameters>
			</method>
			<property name="actor" type="gpointer" readable="1" writable="1" construct="0" construct-only="0"/>
			<property name="label" type="char*" readable="1" writable="1" construct="0" construct-only="0"/>
		</object>
		<object name="CtkToplevel" parent="CtkBin" type-name="CtkToplevel" get-type="ctk_toplevel_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<method name="get_default_for_stage" symbol="ctk_toplevel_get_default_for_stage">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="stage" type="ClutterActor*"/>
				</parameters>
			</method>
			<method name="get_stage" symbol="ctk_toplevel_get_stage">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="self" type="CtkToplevel*"/>
				</parameters>
			</method>
			<method name="set_focus" symbol="ctk_toplevel_set_focus">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="CtkToplevel*"/>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</method>
			<property name="stage" type="ClutterStage*" readable="1" writable="1" construct="1" construct-only="0"/>
		</object>
		<object name="CtkVBox" parent="CtkBox" type-name="CtkVBox" get-type="ctk_vbox_get_type">
			<implements>
				<interface name="ClutterScriptable"/>
				<interface name="CtkFocusable"/>
				<interface name="ClutterContainer"/>
			</implements>
			<constructor name="new" symbol="ctk_vbox_new">
				<return-type type="ClutterActor*"/>
				<parameters>
					<parameter name="spacing" type="guint"/>
				</parameters>
			</constructor>
		</object>
		<interface name="CtkFocusable" type-name="CtkFocusable" get-type="ctk_focusable_get_type">
			<method name="activate" symbol="ctk_focusable_activate">
				<return-type type="void"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</method>
			<method name="can_focus" symbol="ctk_focusable_can_focus">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</method>
			<method name="get_event_type" symbol="ctk_focusable_get_event_type">
				<return-type type="CtkFocusEventType"/>
				<parameters>
					<parameter name="event" type="ClutterKeyEvent*"/>
					<parameter name="direction" type="CtkFocusDirection*"/>
				</parameters>
			</method>
			<method name="get_focused" symbol="ctk_focusable_get_focused">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</method>
			<method name="set_focused" symbol="ctk_focusable_set_focused">
				<return-type type="void"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
					<parameter name="is_focused" type="gboolean"/>
				</parameters>
			</method>
			<vfunc name="activate">
				<return-type type="void"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</vfunc>
			<vfunc name="can_focus">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_focused">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
				</parameters>
			</vfunc>
			<vfunc name="set_focused">
				<return-type type="void"/>
				<parameters>
					<parameter name="focusable" type="CtkFocusable*"/>
					<parameter name="is_focused" type="gboolean"/>
				</parameters>
			</vfunc>
		</interface>
		<constant name="CTK_EFFECT_DEFAULT_MARGIN" type="int" value="0"/>
		<constant name="CTK_EFFECT_DEFAULT_STRENGTH" type="int" value="5"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_DEFAULT_OFFSET_X" type="int" value="0"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_DEFAULT_OFFSET_Y" type="int" value="0"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_MAX_OFFSET_X" type="int" value="100"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_MAX_OFFSET_Y" type="int" value="100"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_MIN_OFFSET_X" type="int" value="-100"/>
		<constant name="CTK_EFFECT_DROP_SHADOW_MIN_OFFSET_Y" type="int" value="-100"/>
		<constant name="CTK_EFFECT_MAX_MARGIN" type="int" value="100"/>
		<constant name="CTK_EFFECT_MAX_STRENGTH" type="int" value="100"/>
		<constant name="CTK_EFFECT_MIN_MARGIN" type="int" value="0"/>
		<constant name="CTK_EFFECT_MIN_STRENGTH" type="int" value="0"/>
		<constant name="CTK_MENU_EXPANDABLE_ANCHOR_SIZE_OFFSET" type="int" value="4"/>
		<constant name="CTK_MENU_EXPANDABLE_CONTENT_PADDING" type="int" value="0"/>
		<constant name="CTK_MENU_EXPANDABLE_CONTENT_PADDING_LEFT_RIGHT" type="int" value="4"/>
		<constant name="CTK_MENU_EXPANDABLE_PADDING" type="int" value="16"/>
		<constant name="CTK_MENU_EXPANDABLE_TRANSITION_STEPS" type="int" value="8"/>
	</namespace>
</api>
