/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_BOX_H_
#define _CTK_BOX_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_BOX (ctk_box_get_type ())

#define CTK_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_BOX, CtkBox))

#define CTK_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_BOX, CtkBoxClass))

#define CTK_IS_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_BOX))

#define CTK_IS_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_BOX))

#define CTK_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_BOX, CtkBoxClass))

typedef struct _CtkBox         CtkBox;
typedef struct _CtkBoxClass    CtkBoxClass;
typedef struct _CtkBoxPrivate  CtkBoxPrivate;
typedef struct _CtkBoxChild    CtkBoxChild;
 
struct _CtkBox
{
  CtkActor parent;	

  CtkBoxPrivate *priv;
};

struct _CtkBoxClass
{
  /*< private >*/
  CtkActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType  ctk_box_get_type (void) G_GNUC_CONST;

void                ctk_box_pack            (CtkBox  *box,
                                                  ClutterActor *child,
                                                  gboolean      expand,
                                                  gboolean      fill);

void                ctk_box_set_homogeneous (CtkBox  *box,
                                                  gboolean      homogeneous);

gboolean            ctk_box_get_homogeneous (CtkBox  *box);

void                ctk_box_set_spacing     (CtkBox      *box,
                                                  gint              spacing);

gint                ctk_box_get_spacing     (CtkBox *box);

void                ctk_box_set_orientation (CtkBox *box,
                                                  CtkOrientation orient);

CtkOrientation      ctk_box_get_orientation (CtkBox *box);

void                ctk_box_sort_children   (CtkBox *box, GCompareFunc func);

G_END_DECLS

#endif /* _CTK_BOX_H_ */

