/* Parse an URL and return an object that can has methods to compare it to other
 * URLs in a way that ignores syntax differences. For example a raw string
 * comparison of http://www.google.com/?#" and http://www.google.com would return
 * false, but they are instead the same URL, and this class recognizes that.
 */

function URL(url) {
   this.source = url;

   var a = document.createElement('a');
   a.href = url;
   this.protocol = a.protocol.replace(':','');
   this.host = a.hostname;
   this.port = a.port;
   this.path = a.pathname.replace(/^([^\/])/,'/$1');
   this.query = a.search;
   this.hash = a.hash.replace('#','');
}

URL.prototype.sameAs = function(other) {
   return (this.protocol === other.protocol &&
           this.host === other.host &&
           this.port === other.port &&
           this.path === other.path &&
           this.query === other.query &&
           this.hash === other.hash);
}

function sameURLs(a, b) {
   if (! (a instanceof URL)) { a = new URL(a); }
   if (! (b instanceof URL)) { b = new URL(b); }
   return a.sameAs(b);
}
