#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import etk
import edje


class DirItemRenderer(etk.EdjeKineticRenderer):
    STATE_NONE, STATE_ALL = range(2)
    states = ["none", "all"]

    def __init__(self, ui_data_func=None, item_click=None, toggle_click=None,
                 *a, **ka):
        if ui_data_func is None:
            raise ValueError("need an ui data function")

        etk.EdjeKineticRenderer.__init__(self)
        self.ui_data_func = ui_data_func
        self.item_click = item_click
        self.toggle_click = toggle_click
        self.args = a
        self.kargs = ka

    def create_cell(self, canvas):
        cell = edje.Edje(canvas)
        etk.theme_edje_object_set(cell, self.list.theme_file,
                                  "dir_item", "canola/conf")
        cell.signal_emit("toggle,set,none", "")
        return cell

    def update_cell(self, cell, row):
        folder, text, state = self.ui_data_func(row)

        if folder:
            cell.signal_emit("icon,show", "")
        else:
            cell.signal_emit("icon,hide", "")
        cell.part_text_set("label", text)
        cell.signal_emit("toggle,set,%s" % self.states[state], "")

    def show_cell(self, cell, x, y, w, h):
        cell.geometry = x, y, w, h
        cell.show()

    def click(self, cell, part, row):
        if part == "toggle_event_area":
            if self.toggle_click:
                self.toggle_click(row, self.list, *self.args, **self.kargs)
        elif part == "event_area":
            cell.signal_emit("item,select", "")
            if self.item_click:
                self.item_click(row, self.list, *self.args, **self.kargs)

    def press(self, cell, part, row):
        if part == "toggle_event_area":
            cell.signal_emit("toggle,press", "")

    def release(self, cell, part, row):
        if part == "toggle_event_area":
            cell.signal_emit("toggle,release", "")
