#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from model import DirectoryModel
from terra.core.manager import Manager

mger = Manager()


def row_value_set(self, value):
    self.part_text_set("text", value.name)
    if isinstance(value, DirectoryModel):
        signal = "icon,show"
    else:
        signal = "icon,hide"
    self.signal_emit(signal, "")


RowRendererFactory = mger.get_class("Widget/SimpleRowRendererFactory")
GenericListController = mger.get_class("Controller/Folder")
class DirectoryListController(GenericListController):
    terra_type = "Controller/Folder/Directory"
    row_renderer = RowRendererFactory(row_value_set, "list_item_fs")
    list_group = "list"
