#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import logging
log = logging.getLogger("plugins.canola-core.audio.player.options")

from terra.core.manager import Manager

mger = Manager()
OptionsModelFolder = mger.get_class("Model/Options/Folder")
OptionsActionModel = mger.get_class("Model/Options/Action")
OptionsCheckedFolderController = \
    mger.get_class("Controller/Options/CheckedFolder")


class AlbumArtOptionsModelFolder(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Media/Audio/AlbumArt"
    title = "Album Options"


class AlbumGridOptionsModelFolder(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Media/Audio/Local/AlbumArt"
    title = "Album Options"


class AudioPlayerOptionsCheckedController(OptionsCheckedFolderController):
    terra_type = "Controller/Options/Folder/Player/Audio"


class AudioPlayerOptionsModel(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Player/Audio"
    title = "Audio Options"
    children_order = ["/Action/Player/Audio/Shuffle",
                      "/Action/Player/Audio/Repeat"]
    children_prefixes = ["Model/Options/Action/Player/Audio"]


class AudioOnTheGoOptionsMF(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Media/Audio/Local/Playlist/OnTheGo"
    title = "On The Move Options"
    children_prefixes = ["Model/Options/Action/Media/Audio/Local/Playlist/OnTheGo"]


class ShuffleOptionModel(OptionsActionModel):
    terra_type = "Model/Options/Action/Player/Audio/Shuffle"
    name = "Shuffle"

    def __init__(self, parent=None):
        OptionsActionModel.__init__(self, parent)
        self.update()

    def update(self):
        self.checked = self.screen_controller.shuffle

    def execute(self):
        self.screen_controller.shuffle = not self.screen_controller.shuffle
        self.update()


class RepeatOptionModel(OptionsActionModel):
    terra_type = "Model/Options/Action/Player/Audio/Repeat"
    name = "Repeat"

    def __init__(self, parent=None):
        OptionsActionModel.__init__(self, parent)
        self.update()

    def update(self):
        self.checked = self.screen_controller.repeat

    def execute(self):
        self.screen_controller.repeat = not self.screen_controller.repeat
        self.update()


class SaveOnTheGoPlaylistModel(OptionsActionModel):
    terra_type = "Model/Options/Action/Media/Audio/Local/Playlist/OnTheGo/Save"
    name = "Save Playlist"
    stack = False

    def save_playlist(self, text, force=False):
        # FIXME, GET RIGHT PATH
        return self.screen_controller.save_playlist(text, force=force)


class ClearOnTheGoPlaylistModel(OptionsActionModel):
    terra_type = "Model/Options/Action/Media/Audio/Local/Playlist/OnTheGo/Clear"
    name = "Clear Playlist"

    def clear_playlist(self):
        self.screen_controller.clear_playlist()
