#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import os
import logging

import evas.decorators

from terra.core.manager import Manager
from terra.ui.grid import CellRenderer
from terra.ui.base import EdjeWidget

__all__ = ("CellRendererWidget", "KineticVGridWidget",
           "ScrollbarWidget", "KnobWidget",)

log = logging.getLogger("canola.ui.album_set")
mger = Manager()
KineticVGridWidget = mger.get_class("Widget/KineticVGrid")
ScrollbarWidget = mger.get_class("Widget/Scrollbar")
KnobWidget = mger.get_class("Widget/Knob")


class CellRendererWidget(EdjeWidget, CellRenderer):
    def __init__(self, parent, theme=None):
        EdjeWidget.__init__(self, parent.evas, "album_set_item", parent, theme)
        self._model = None
        self._img = self.evas.FilledImage()
        self._cover = self.part_swallow_get("cover")
        self.part_swallow("contents", self._img)
        self._cover.signal_emit("cover,hide", "")

    @evas.decorators.del_callback
    def on_del(self):
        self._img.delete()

    def theme_changed(self):
        EdjeWidget.theme_changed(self)
        self._cover = self.part_swallow_get("cover")
        self.part_swallow("contents", self._img)
        self.force_redraw()

    def force_redraw(self):
        m = self._model
        self._model = None
        self.value_set(m)

    def value_set(self, v):
        if self._model is v or v is None:
            return
        if not os.path.exists(v):
            self._cover.signal_emit("cover,hide", "")
        else:
            try:
                self._img.file_set(v)
                self._cover.part_swallow("album_cover", self._img)
                self._cover.signal_emit("cover,show", "")
            except Exception, e:
                log.error("could not load image %r: %s", v, e)
                self._cover.signal_emit("cover,hide", "")
