from ufaspy.tests.introspection import BaseIntrospectionTestCase


class MessagesTest(BaseIntrospectionTestCase):
    def setUp(self):
        super(MessagesTest, self).setUp()
        self.dbus_interface = "com.canonical.android.messages.Messages"
        self.s_MessageAdded = "MessageAdded"
        self.s_messageReceived = "messageReceived"
        self.s_MessageRemoved = "MessageRemoved"
        self.s_MessagesChanged = "MessagesChanged"
        self.s_mmsAvailable = "mmsAvailable"
        self.m_getLastMessage = "getLastMessage"
        self.m_getMMSDetails = "getMMSDetails"
        self.m_listConversationsBegin = "listConversationsBegin"
        self.m_listConversationsEnd = "listConversationsEnd"
        self.m_listConversationsNextPage = "listConversationsNextPage"
        self.m_listMessagesBegin = "listMessagesBegin"
        self.m_listMessagesEnd = "listMessagesEnd"
        self.m_listMessagesNextPage = "listMessagesNextPage"
        self.m_markMMSAsRead = "markMMSAsRead"
        self.m_sendMessage = "sendMessage"

    def tearDown(self):
        super(MessagesTest, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_mess.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_messages_s_MessageAdded(self):
        item = self.s_MessageAdded
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_messages_s_messageReceived(self):
        item = self.s_messageReceived
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_messages_s_MessageRemoved(self):
        item = self.s_MessageRemoved
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_messages_s_MessagesChanged(self):
        item = self.s_MessagesChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_messages_s_mmsAvailable(self):
        item = self.s_mmsAvailable
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_messages_m_getLastMessage(self):
        item = self.m_getLastMessage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_getMMSDetails(self):
        item = self.m_getMMSDetails
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listConversationsBegin(self):
        item = self.m_listConversationsBegin
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listConversationsEnd(self):
        item = self.m_listConversationsEnd
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listConversationsNextPage(self):
        item = self.m_listConversationsNextPage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listMessagesBegin(self):
        item = self.m_listMessagesBegin
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listMessagesEnd(self):
        item = self.m_listMessagesEnd
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_listMessagesNextPage(self):
        item = self.m_listMessagesNextPage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_markMMSAsRead(self):
        item = self.m_markMMSAsRead
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_messages_m_sendMessage(self):
        item = self.m_sendMessage
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
