from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestDT(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestDT, self).setUp()
        self.dbus_interface = "com.canonical.android.datetime.DateTime"
        self.s_TimeUpdated = "TimeUpdated"
        self.s_TimeZoneChanged = "TimeZoneChanged"
        self.m_getTime = "getTime"
        self.m_getTimeZone = "getTimeZone"

    def tearDown(self):
        super(TestDT, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_dt.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_datetime_TimeUpdated(self):
        item = self.s_TimeUpdated
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_datetime_s_TimeZoneChanged(self):
        item = self.s_TimeZoneChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_datetime_m_getTime(self):
        item = self.m_getTime
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_datetime_m_getTimeZone(self):
        item = self.m_getTimeZone
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
