/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mso.generator.QtParserGenerator;
import mso.generator.utils.Choice;
import mso.generator.utils.Limitation;
import mso.generator.utils.MSO;
import mso.generator.utils.Member;
import mso.generator.utils.Option;
import mso.generator.utils.Struct;
import mso.generator.utils.TypeRegistry;

public class QtApiGenerator {
    public final QtApiConfiguration config = new QtApiConfiguration();
    private final String generatedWarning = "/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */";
    private final Pattern pattern1 = Pattern.compile("(?<=\\W)([a-zA-Z]\\w*)(?=\\W|$)");
    private final Pattern pattern2 = Pattern.compile("(^[a-zA-Z]\\w*)(?=\\W|$)");

    void generate(MSO mSO) throws IOException {
        FileWriter fileWriter = this.config.createHeader ? new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".h") : new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
        if (this.config.createHeader) {
            printWriter.println("#ifndef " + this.config.basename.toUpperCase() + "_H");
            printWriter.println("#define " + this.config.basename.toUpperCase() + "_H");
        }
        printWriter.println("#include \"leinput.h\"");
        printWriter.println("namespace " + this.config.namespace + "{");
        for (Struct struct : mSO.structs) {
            printWriter.println("class " + struct.name + ";");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureClassDeclaration(printWriter, struct);
        }
        if (this.config.createHeader) {
            printWriter.println("} // close namespace");
            printWriter.println("#endif");
            printWriter.close();
            fileWriter = new FileWriter(this.config.outputdir + File.separator + this.config.basename + ".cpp");
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("/* This code was generated by msoscheme (http://gitorious.org/msoscheme) */");
            printWriter.println("#include \"" + this.config.basename + ".h\"");
        }
        for (Struct struct : mSO.structs) {
            this.printStructureDefinition(printWriter, struct);
        }
        if (!this.config.createHeader) {
            printWriter.println("}");
        }
        printWriter.close();
        fileWriter.close();
    }

    private void printStructureClassDeclaration(PrintWriter printWriter, Struct struct) {
        if (struct.size == -1) {
            printWriter.println("class " + struct.name + " : public ParsedObject {");
        } else {
            printWriter.println("class " + struct.name + " : public FixedSizeParsedObject {");
        }
        printWriter.println("private:");
        if (struct.size == -1) {
            printWriter.println("public:");
            printWriter.println("    " + struct.name + "() {}");
            printWriter.println("    explicit " + struct.name + "(const char* data, const quint32 maxsize);");
        } else {
            printWriter.println("    static const quint32 _size;");
            printWriter.println("public:");
            printWriter.println("    static inline quint32 getSize() { return _size; }");
            printWriter.println("    " + struct.name + "() {}");
            printWriter.println("    " + struct.name + "(const char* data, quint32/*ignored*/ = 0);// " + struct.size / 8 + " bytes");
        }
        for (Member member : struct.members) {
            this.printMemberDeclaration(printWriter, member, struct.name);
        }
        printWriter.println("};");
    }

    private String definitionPrefix() {
        return this.config.namespace == null || this.config.namespace.length() == 0 ? "" : this.config.namespace + "::";
    }

    private void printStructureDefinition(PrintWriter printWriter, Struct struct) {
        String string = this.definitionPrefix() + struct.name + "::";
        if (struct.size == -1) {
            printWriter.println(string + struct.name + "(const char* _d, quint32 _maxsize) {");
        } else {
            printWriter.println("const quint32 " + string + "_size = " + struct.size / 8 + ";");
            printWriter.println(string + struct.name + "(const char* _d, quint32/*ignored*/) {");
        }
        printWriter.println("    quint32 _position = 0;");
        printWriter.println("    quint32 _msize;");
        int n = 0;
        for (Member member : struct.members) {
            String string2 = "    ";
            int n2 = this.getSize(member);
            String string3 = member.condition;
            if (member.isSimple && string3 != null) {
                string3 = this.fixForMemberName(string3);
                printWriter.println(string2 + "bool _has_" + member.name + " = " + string3 + ";");
                string3 = "_has_" + member.name;
            }
            if (string3 != null) {
                string3 = this.fixForMemberName(string3);
                printWriter.println(string2 + "if (" + string3 + ") {");
                string2 = "        ";
            }
            if (n2 != -1 && struct.size == -1) {
                printWriter.print(string2 + "if (_position + " + n2);
                if (member.isOptional) {
                    string2 = string2 + "    ";
                    printWriter.println(" <= _maxsize) {");
                } else {
                    printWriter.println(" > _maxsize) return;");
                }
            }
            n = this.printMemberParser(printWriter, string2, struct, member, n);
            this.printLimitationCheck(printWriter, string2, member.name, member);
            printWriter.println(string2 + "_position += _msize;");
            while (string2.length() > 4) {
                string2 = string2.substring(string2.length() - 4);
                printWriter.println(string2 + "}");
            }
        }
        if (struct.size == -1) {
            printWriter.println("   ParsedObject::init(_d, _position);");
        } else {
            printWriter.println("   FixedSizeParsedObject::init(_d);");
        }
        printWriter.println("}");
        for (Member member : struct.members) {
            if (member.isArray && member.isStruct || !member.isChoice) continue;
            this.printChoiceAccessor(printWriter, struct, member);
        }
    }

    private int printMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        if (member.isArray) {
            if (member.isSimple) {
                this.printSimpleArrayMemberParser(printWriter, string, struct, member);
            } else {
                this.printStructArrayMemberParser(printWriter, string, struct, member);
            }
            if (member.isChoice) {
                throw new Error("There should be no choice in an array.");
            }
        } else {
            if (member.isSimple) {
                return this.printSimpleMemberParser(printWriter, string, struct, member, n);
            }
            if (member.isStruct) {
                this.printStructMemberParser(printWriter, string, struct, member);
            } else if (member.isChoice) {
                this.printChoiceMemberParser(printWriter, string, struct, member);
            }
        }
        return 0;
    }

    private int printSimpleMemberParser(PrintWriter printWriter, String string, Struct struct, Member member, int n) {
        printWriter.println(string + "m_" + member.name + " = read" + member.type().name + (n > 0 ? "_" + String.valueOf(n) : "") + "(_d + _position);");
        int n2 = member.type().size / 8;
        if (n != 0 && (n + member.type().size) % 8 == 0) {
            ++n2;
        }
        n = (n + member.type().size) % 8;
        printWriter.println(string + "_msize = " + n2 + ";");
        return n;
    }

    private int getSize(Member member) {
        int n = -1;
        if (member.count != null && member.isArray && member.type().size != -1) {
            try {
                n = member.type().size * Integer.parseInt(member.count) / 8;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (member.size != null) {
            try {
                n = Integer.parseInt(member.size);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        } else if (!member.isArray) {
            return member.type().size / 8;
        }
        return n;
    }

    private void printSimpleArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size % 8 != 0) {
            throw new Error("only arrays of types with a size of a multiple of 8 bits are allowed.");
        }
        int n = this.getSize(member);
        String string2 = String.valueOf(n * 8 / member.type().size);
        if (n == -1) {
            string2 = member.count != null ? member.count : "(" + member.size + ")/" + member.type().size / 8;
        } else if (n % (member.type().size / 8) != 0) {
            throw new Error("array size must be a multiple of the size of the type for " + member.type().name + " and size " + n);
        }
        string2 = this.fixForMemberName(string2);
        String string3 = this.getTypeName(member.type());
        if ("quint8".equals(string3)) {
            string3 = "char";
        }
        printWriter.println(string + "m_" + member.name + " = MSOCastArray<" + string3 + ">((const " + string3 + "*)(_d + _position), " + string2 + ");");
        printWriter.println(string + "_msize = (" + string2 + ")*" + member.type().size / 8 + ";");
    }

    private void printStructArrayMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.count != null) {
            String string2 = "_maxsize - _position, ";
            String string3 = this.fixForMemberName(member.count);
            if (member.type().size != -1) {
                string2 = member.type().size / 8 + " * " + string3 + ", ";
            }
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, " + string2 + string3 + ");");
            printWriter.println(string + "if (m_" + member.name + ".getCount() != " + string3 + ") return;");
        } else if (member.size != null) {
            String string4 = this.fixForMemberName(member.size);
            printWriter.println(string + "if (_maxsize - _position < " + string4 + ") return;");
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, " + string4 + ");");
            printWriter.println(string + "if (m_" + member.name + ".getSize() != " + string4 + ") return;");
        } else {
            printWriter.println(string + "m_" + member.name + " = MSOArray<" + member.type().name + ">(_d + _position, _maxsize - _position);");
            printWriter.println(string + "if (!m_" + member.name + ".isValid()) return;");
        }
        printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
    }

    private void printStructMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        if (member.type().size == -1) {
            printWriter.println(string + "m_" + member.name + " = " + member.type().name + "(_d + _position, _maxsize - _position);");
        } else {
            printWriter.println(string + "m_" + member.name + " = " + member.type().name + "(_d + _position);");
        }
        if (member.isOptional) {
            printWriter.println(string + "_msize = (m_" + member.name + ".isPresent()) ?m_" + member.name + ".getSize() :0;");
        } else if (member.condition != null) {
            printWriter.println(string + "if (!m_" + member.name + ".isPresent()) return;");
            printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
        } else {
            printWriter.println(string + "if (!m_" + member.name + ".isValid()) return;");
            printWriter.println(string + "_msize = m_" + member.name + ".getSize();");
        }
    }

    private void printChoiceMemberParser(PrintWriter printWriter, String string, Struct struct, Member member) {
        Choice choice = (Choice)member.type();
        boolean bl = true;
        String string2 = string;
        for (Option option : choice.options) {
            Struct struct2 = option.type;
            if (!bl) {
                printWriter.println(string + "if (_msize == 0) {");
            }
            String string3 = "m_" + member.name + "._" + struct2.name;
            if (struct2.size == -1) {
                printWriter.println(string2 + string3 + " = " + struct2.name + "(_d + _position, _maxsize - _position);");
                printWriter.println(string2 + "_msize = " + string3 + ".getSize();");
            } else {
                printWriter.println(string2 + string3 + " = " + struct2.name + "(_d + _position);");
                printWriter.println(string2 + "_msize = (" + string3 + ".isValid()) ?" + struct2.name + "::getSize() : 0;");
            }
            if (!bl) {
                printWriter.println(string + "}");
            } else {
                string2 = string + "    ";
            }
            bl = false;
        }
        if (!member.isOptional) {
            printWriter.println(string + "if (_msize == 0) return;");
        }
    }

    private String getTypeName(TypeRegistry.Type type) {
        TypeRegistry typeRegistry = type.registry;
        if (type instanceof Choice) {
            return type.name;
        }
        if (type == typeRegistry.bit) {
            return "bool";
        }
        if (type == typeRegistry.uint2 || type == typeRegistry.uint3 || type == typeRegistry.uint4 || type == typeRegistry.uint5 || type == typeRegistry.uint6 || type == typeRegistry.uint7 || type == typeRegistry.uint8) {
            return "quint8";
        }
        if (type == typeRegistry.uint9 || type == typeRegistry.uint12 || type == typeRegistry.uint13 || type == typeRegistry.uint14 || type == typeRegistry.uint15 || type == typeRegistry.uint16) {
            return "quint16";
        }
        if (type == typeRegistry.uint20 || type == typeRegistry.uint30 || type == typeRegistry.uint32) {
            return "quint32";
        }
        if (type == typeRegistry.int16) {
            return "qint16";
        }
        if (type == typeRegistry.int32) {
            return "qint32";
        }
        return type.name;
    }

    private void printChoiceAccessor(PrintWriter printWriter, TypeRegistry.Type type, Member member) {
        Choice choice = (Choice)member.type();
        printWriter.println("namespace " + this.config.namespace + " {");
        for (Option option : choice.options) {
            String string = option.type.name;
            printWriter.println("    template <> " + string + " " + type.name + "::C_" + member.name + "::get<" + string + ">() const {");
            printWriter.println("        return _" + string + ";");
            printWriter.println("    }");
            printWriter.println("    template <> bool " + type.name + "::C_" + member.name + "::is<" + string + ">() const {");
            printWriter.println("        return _" + string + ".isValid();");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    private void printMemberDeclaration(PrintWriter printWriter, Member member, String string) {
        String string2 = this.getTypeName(member.type());
        if (member.isArray) {
            if (member.isSimple) {
                if ("quint8".equals(string2)) {
                    string2 = "char";
                }
                printWriter.println("private:");
                printWriter.println("    MSOCastArray<" + string2 + "> m_" + member.name + ";");
                printWriter.println("public:");
                printWriter.println("    const MSOCastArray<" + string2 + ">& " + member.name + "() const { return m_" + member.name + "; }");
            }
            if (member.isStruct || member.isChoice) {
                if (member.type().size == -1) {
                    printWriter.println("private:");
                    printWriter.println("    MSOArray<" + string2 + "> m_" + member.name + ";");
                    printWriter.println("public:");
                    printWriter.println("    inline const MSOArray<" + string2 + ">& " + member.name + "() const { return m_" + member.name + "; }");
                } else {
                    printWriter.println("private:");
                    printWriter.println("    MSOArray<" + string2 + "> m_" + member.name + ";");
                    printWriter.println("public:");
                    printWriter.println("    inline const MSOArray<" + string2 + ">& " + member.name + "() const { return m_" + member.name + "; }");
                }
            }
        } else if (member.isChoice) {
            Choice choice = (Choice)member.type();
            printWriter.println("public:");
            printWriter.println("    class C_" + member.name + " {");
            printWriter.println("    friend class " + string + ";");
            printWriter.println("    private:");
            for (Option option : choice.options) {
                Struct struct = option.type;
                printWriter.println("        " + struct.name + " _" + struct.name + ";");
            }
            printWriter.println("    public:");
            printWriter.println("        template <typename A> A get() const;");
            printWriter.println("        template <typename A> bool is() const;");
            printWriter.println("    };");
            printWriter.println("private:");
            printWriter.println("    C_" + member.name + " m_" + member.name + ";");
            printWriter.println("public:");
            printWriter.println("    C_" + member.name + " " + member.name + "() const { return m_" + member.name + "; }");
        } else {
            if (member.isOptional || member.condition != null) {
                string2 = member.isSimple ? "MSOBasicNullable<" + string2 + ">" : "MSONullable<" + string2 + ">";
            }
            printWriter.println("private:");
            printWriter.println("    " + string2 + " m_" + member.name + ";");
            printWriter.println("public:");
            if (!member.isSimple || member.isOptional || member.condition != null) {
                string2 = "const " + string2 + "&";
            }
            printWriter.println("    inline " + string2 + " " + member.name + "() const { return m_" + member.name + "; }");
        }
    }

    private void printLimitationCheck(PrintWriter printWriter, String string, String string2, Member member) {
        if (member.type() instanceof Choice) {
            return;
        }
        for (Limitation limitation : member.limitations) {
            String string3;
            String string4 = limitation.name;
            string4 = !"".equals(string4) ? string2 + "." + string4 : string2;
            if (!member.isStruct) {
                string4 = member.condition == null ? "((" + this.getTypeName(member.type()) + ")m_" + string4 + ")" : "((" + this.getTypeName(member.type()) + ")*m_" + string4 + ")";
            }
            string3 = (string3 = limitation.expression) == null ? QtParserGenerator.getCondition(string4, limitation) : QtParserGenerator.getExpression(string4, string3);
            if (member.isStruct) {
                string3 = this.fixForMemberName(string3);
            }
            printWriter.println(string + "if (!(" + string3 + ")) {");
            printWriter.println(string + "     return;");
            printWriter.println(string + "}");
        }
    }

    private boolean isNumber(String string) {
        boolean bl = true;
        try {
            Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private String fix(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            if (!this.isNumber(string2)) {
                string2 = string2 + "()";
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String fixForMemberName(String string) {
        if (string.startsWith("_has_")) {
            return string;
        }
        string = this.fix(string, this.pattern1);
        string = this.fix(string, this.pattern2);
        string = string.replaceAll("false\\(\\)", "false");
        string = string.replaceAll("true\\(\\)", "true");
        return string;
    }

    public class QtApiConfiguration {
        public String namespace;
        public String outputdir;
        public String basename;
        public boolean createHeader;
    }
}

