#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
www.rts.rs
'''

import re
from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import Tag

class RTS(BasicNewsRecipe):
    title                 = 'RTS: Vesti'
    __author__            = 'Darko Miletic'
    description           = 'News from Serbia'
    publisher             = 'RTS'
    category              = 'news, politics, Serbia, RTS'
    no_stylesheets        = True
    encoding              = 'utf-8'
    use_embedded_content  = True
    language = 'sr'

    lang                  = 'sr-Latn-RS'
    extra_css = '@font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif1, serif} .article_description{font-family: serif1, serif}'

    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        }


    preprocess_regexps = [(re.compile(u'\u0110'), lambda match: u'\u00D0')]

    feeds = [
               (u'Vesti'         , u'http://www.rts.rs/page/stories/sr/rss.html'                 )
              ,(u'Srbija'        , u'http://www.rts.rs/page/stories/sr/rss/9/Srbija.html'        )
              ,(u'Region'        , u'http://www.rts.rs/page/stories/sr/rss/11/Region.html'       )
              ,(u'Svet'          , u'http://www.rts.rs/page/stories/sr/rss/10/Svet.html'         )
              ,(u'Hronika'       , u'http://www.rts.rs/page/stories/sr/rss/135/Hronika.html'     )
              ,(u'Drustvo'       , u'http://www.rts.rs/page/stories/sr/rss/125/Dru%C5%A1tvo.html')
              ,(u'Ekonomija'     , u'http://www.rts.rs/page/stories/sr/rss/13/Ekonomija.html'    )
              ,(u'Nauka'         , u'http://www.rts.rs/page/stories/sr/rss/14/Nauka.html'        )
              ,(u'Kultura'       , u'http://www.rts.rs/page/stories/sr/rss/16/Kultura.html'      )
              ,(u'Zanimljivosti' , u'http://www.rts.rs/page/stories/sr/rss/15/Zanimljivosti.html')
              ,(u'Sport'         , u'http://www.rts.rs/page/sport/sr/rss.html'                   )
            ]

    def preprocess_html(self, soup):
        soup.html['xml:lang'] = self.lang
        soup.html['lang']     = self.lang
        mlang = Tag(soup,'meta',[("http-equiv","Content-Language"),("content",self.lang)])
        mcharset = Tag(soup,'meta',[("http-equiv","Content-Type"),("content","text/html; charset=UTF-8")])
        soup.head.insert(0,mlang)
        soup.head.insert(1,mcharset)
        return self.adeify_images(soup)

