#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <strings.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <glib.h>
#include <signal.h>
#include "string.h"
#ifdef ENABLE_SKYPEAPP_PRINTS
#define MY_PRINTF printf
#else
#define MY_PRINTF
#endif
#define INDEX_OF_CALL_NUM 5 /* index after CALL */


static DBusHandlerResult signal_filter 
   (DBusConnection *connection, DBusMessage *message, void *user_data);

char *sendToSkype( char *msg);

DBusConnection *connection= NULL;
DBusConnection *sys_connection= NULL;
DBusError error;
DBusMessage *message;
DBusMessage *reply;
GMainLoop *loop;
FILE *fp=NULL;
static void install_notify_handler (
  DBusConnection *bus, DBusObjectPathVTable *vtable);
static DBusHandlerResult notify_handler (
  DBusConnection *bus, DBusMessage *msg, void *user_data);

char call_num[20];
char lastDialnumber[80];
int last_outgoingcall_present = 0;

static void get_call_num(char *notify_argument)
{
   int i=0;
   int index_val = INDEX_OF_CALL_NUM;
   while(notify_argument[index_val] != ' ')
   {
      call_num[i++] = notify_argument[index_val++];
   }
}

static void get_caller_name(char *notify_argument)
{
/* find the last space character i.e,get pointer to the space character after PARTNER_HANDLE in order to get the username */
   
   char *pointer = rindex(notify_argument,' '); /* pointer to the P */
   //MY_PRINTF("value of pointer is %s\n",pointer);
   memcpy(lastDialnumber,pointer,strlen(pointer));
   lastDialnumber[strlen(pointer)] = '\0';
   last_outgoingcall_present = 1;
}
typedef enum call_type
{
 CALL_INACTIVE=0,
 CALL_OUTGOING,
 CALL_INCOMING,
 CALL_ACTIVE

}te_call_status;

te_call_status call_status = FALSE;


/* This Function is invoked by Skype on receiving Notify from Skype 
 * popen is used instead of system to execute commands */
char send_string[80]= " ";
static DBusHandlerResult notify_handler (
  DBusConnection *bus, DBusMessage *msg, void *user_data)
{
  char *notify_argument=0;
  memset(send_string,0,80);
  dbus_message_get_args ( msg, 0, DBUS_TYPE_STRING, &notify_argument, DBUS_TYPE_INVALID);
  //MY_PRINTF("Notify: %s \n", notify_argument,call_status);
  /* Check if this Outgoing Call */ 
  if( (call_status == CALL_INACTIVE) && strstr(notify_argument,"CALL") && (strstr(notify_argument,"STATUS UNPLACED") || strstr(notify_argument,"STATUS ROUTING")))
  {
   memset(send_string,0,sizeof(send_string));
   call_status = CALL_OUTGOING;
   get_call_num(notify_argument);
   MY_PRINTF("outgoing call started to number %s\n",call_num);
   strcat(send_string ,"python /usr/local/sbin/test-telephony outgoing ");  
   strcat(send_string,call_num);
   //MY_PRINTF("Executing Python command :%s\n",send_string);
   fp = popen(send_string,"r");
   MY_PRINTF("sent outgoing ind to BLuez\n");
   fclose(fp);
   memset(send_string,0,sizeof(send_string));
   /* Get the UserId of the Last Dialed outgoing Call */
   strcat(send_string,"GET CALL ");
   strcat(send_string,call_num);
   strcat(send_string," PARTNER_HANDLE");
   notify_argument = sendToSkype(send_string);
   //MY_PRINTF("Result of get PARTNER_HANDLE is %s\n",notify_argument);
   get_caller_name(notify_argument);
   MY_PRINTF("lastDial Number is %s\n",lastDialnumber);
   
  }
  else if( (call_status == CALL_INACTIVE) && strstr(notify_argument,"CALL") && 
   strstr(notify_argument,"STATUS RINGING"))
  {

      /* If CALLS Ringing save the number*/
      get_call_num(notify_argument);
      memset(send_string,0,sizeof(send_string));
      strcat(send_string ,"python /usr/local/sbin/test-telephony incoming ");  
      strcat(send_string,call_num);
      strcat(send_string," 129");
      fp = popen(send_string,"r");
      //MY_PRINTF("received incoming call Notification: Execute  :%s/n",send_string);
      call_status = CALL_INCOMING;
      fclose(fp);
  }
  else if(strstr(notify_argument ,"CALL") && (strstr(notify_argument,"STATUS FINISHED") || 
   strstr(notify_argument,"STATUS REFUSED") || strstr(notify_argument,"STATUS CANCELLED") || (strstr(notify_argument,"STATUS FAILED"))))
  {
   /* Since the Call Has Ended */
   call_status = CALL_INACTIVE;
   /* update bluez that call is dropped */
   fp= popen("python /usr/local/sbin/test-telephony cancel","r");
   MY_PRINTF("Call status changed to CALL_INACTIVE\n");
   fclose(fp);

  }
  else if((call_status == CALL_OUTGOING || call_status == CALL_INCOMING)  && strstr(notify_argument,"STATUS INPROGRESS"))
  {
      fp = popen("python /usr/local/sbin/test-telephony OutgoingCallAnswered","r");
      MY_PRINTF("outgoing/incoming call was answered, informed bluez also\n");
      call_status = CALL_ACTIVE;
      fclose(fp);
  }
 else
{
  
  //MY_PRINTF("Notify: %s %d\n", notify_argument,call_status);
}
  return DBUS_HANDLER_RESULT_HANDLED;
}


static void install_notify_handler ( DBusConnection *bus, DBusObjectPathVTable *vtable)
{
  dbus_bool_t check;
  vtable->message_function=notify_handler;
  // We will process messages with the object path "/com/Skype/Client".
  check=dbus_connection_register_object_path (bus, "/com/Skype/Client", vtable, 0);
  if(!check)
  {
   MY_PRINTF("Registeration Failed\n");
   exit(1); 
  }
}

/* This Function Checks if Skype is already Started ,if not It Exits */
static void detect_skype()
{
   char output[40] = "SkypeNotRunning";
   
   fp = popen("ps -ef|grep -v grep|grep skype","r");
   
   fscanf(fp,"%s",output);   
   
   if(strstr(output,"SkypeNotRunning"))
   {
      printf("Skype is not Started..Start this Application after Skype Starts");
      exit (1);
   }
   
   fclose(fp);

}


int main (int argc, char **argv)
{

   char *tmp;
   DBusObjectPathVTable vtable;
   
/* Check if Skype is Running */
   detect_skype();
   /* Create a new event loop to run in. */
   loop=g_main_loop_new(NULL, FALSE);
   dbus_error_init (&error);

   /* Get a connection to the session bus. */

   connection = dbus_bus_get (DBUS_BUS_SESSION, &error);
   if (connection == NULL)
   {
      fprintf(stderr, "Failed to open connection to bus: %s\n",
               error.message);
      dbus_error_free (&error);
      exit (1);
   }
   /* Set up this connection to work in a GLib event loop. */
   dbus_connection_setup_with_g_main(connection, NULL);

   /* Install notify handler to process Skype's notifications.
    The Skype-to-client method call. */
   install_notify_handler(connection, &vtable);

   sys_connection = dbus_bus_get (DBUS_BUS_SYSTEM, &error);
   if (connection == NULL)
   {
      fprintf(stderr, "Failed to open connection to bus: %s\n",
               error.message);
      dbus_error_free (&error);
      exit (1);
   }

   /* Install the signal Receiver from BlueZ */

   dbus_bus_add_match(sys_connection,"type='signal',interface='org.bluez.Headset'",&error);
   
   dbus_connection_setup_with_g_main(sys_connection, NULL);

   dbus_connection_add_filter (sys_connection, signal_filter, NULL, NULL);
   fp = popen("python /usr/local/sbin/test-telephony lastDialMemory yes","r");
   fclose(fp);

   tmp = sendToSkype("NAME CSRSkype");
   if(!strstr(tmp,"OK"))
   {
	printf("User did not allow SKype wireless calls over bluetooth %s\n",tmp);
	exit (1);
   }
   tmp = sendToSkype("PROTOCOL 7");
   tmp = sendToSkype("SET AUDIO_IN hfp");
   tmp = sendToSkype("SET AUDIO_OUT hfp");
   tmp = sendToSkype("SET RINGER  hfp");
   MY_PRINTF("BlueZ is now Connected to Skype\n");
   // Start the event loop.
   
   g_main_loop_run(loop);
   dbus_connection_remove_filter(sys_connection, signal_filter, NULL);
   dbus_connection_unref(connection);
   dbus_connection_unref(sys_connection);
   g_main_loop_unref(loop);
   connection = sys_connection = NULL;
   return 0;
   


}

char *sendToSkype( char *msg)
{

   char *tmp;
   int reply_timeout = -1;   /*don't timeout*/

   DBusMessageIter args;
   

   /* Construct the message */
   message = dbus_message_new_method_call("com.Skype.API",    /*service*/
                  "/com/Skype",       /*path*/
                  "com.Skype.API",  /*interface*/
                  "Invoke"); 

   if(NULL == message)
   {
      fprintf(stderr,"message null\n");
      return NULL;
   }

   dbus_message_iter_init_append(message, &args);
   if (!dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING, &msg))
   {
      fprintf(stderr, "Out Of Memory!\n");
      exit (1);
   }

   reply_timeout = -1;   /*don't timeout*/
   reply = dbus_connection_send_with_reply_and_block (connection, message, reply_timeout, &error); 
   if (dbus_error_is_set (&error))
   {
      fprintf (stderr, "Error: %s\n", error.message);
      dbus_error_free (&error);
      exit (1);
   }
   dbus_message_get_args( reply, &error,
      DBUS_TYPE_STRING, &tmp,
      DBUS_TYPE_INVALID);
   if (dbus_error_is_set (&error)){
      fprintf (stderr, "Error: %s\n", error.message);
      dbus_error_free (&error);
      exit (1);
   }

   return tmp;
}
/* This function is used  to listen for messages on SYSTEM_BUS sent by BlueZ */

static DBusHandlerResult signal_filter (DBusConnection *connection, DBusMessage *message, void *user_data)
{
   char *tmp;
   /* to see what message was received
   const char *n;
   n = dbus_message_get_member (message);
    MY_PRINTF("Inside signal_filter \n");
    MY_PRINTF("received %s\n",n); */

  
 if (dbus_message_is_signal (message, "org.bluez.Headset", "RedialRequested")) 
 {
   /* Redial Requested from Headset */
   if(last_outgoingcall_present)
   {
    
    memset(send_string,0,80);
    strcat(send_string,"CALL ");
    strcat(send_string,lastDialnumber);
    tmp = sendToSkype(send_string);
    MY_PRINTF("Sent the Redial Request to Skype\n");
   }
   else
   {
      fp = popen("python /usr/local/sbin/test-telephony cancel","r");
      MY_PRINTF("Redial Requested but no last Dialed Number informed BlueZ\n");
      
   }
      return DBUS_HANDLER_RESULT_HANDLED;
 }
 if (dbus_message_is_signal (message, "org.bluez.Headset", "IncomingCallAccepted")) 
 {
    MY_PRINTF("Headset has  Accepted IncomingCall,");
    if( call_status == CALL_INCOMING )
    {
     memset(send_string,0,80);
     strcat(send_string,"SET CALL ");
     strcat(send_string,call_num);
     strcat(send_string," STATUS INPROGRESS");
     tmp = sendToSkype(send_string);
     MY_PRINTF(" Also Notified Skype Accept IncomingCall:Skype Response: %s\n" ,tmp);
     call_status = CALL_ACTIVE;
    }
    return DBUS_HANDLER_RESULT_HANDLED;

 }
 if  (dbus_message_is_signal (message, "org.bluez.Headset", "Disconnected"))
 {
   MY_PRINTF( "Bluetooth Headset Has got disconnected,Change the Skype Sound Options to Default Speakers\n");
   call_status = CALL_INACTIVE;
   return DBUS_HANDLER_RESULT_HANDLED;
 }
 if  (dbus_message_is_signal (message, "org.bluez.Headset", "CallTerminated"))
 {

   memset(send_string,0,80);
   strcat(send_string,"SET CALL ");
   strcat(send_string,call_num);
   if(call_status != CALL_INACTIVE )
   {
     strcat(send_string," STATUS FINISHED");
   }
   else
   {
      MY_PRINTF("Ignoring CallTerminated as call is not active");
      return DBUS_HANDLER_RESULT_HANDLED;
   }
   tmp = sendToSkype(send_string);
   MY_PRINTF("Informed Skype for Call Termination:Response from skype %s \n",tmp);
   call_status = CALL_INACTIVE;
      return DBUS_HANDLER_RESULT_HANDLED;

 }
 return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

