/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ENTRY_H__
#define __BKL_ENTRY_H__

#include <glib.h>
#include <kozo.h>

G_BEGIN_DECLS

#define N_BKL_FIELD_TYPE 8
typedef enum _BklFieldType {
    BKL_FIELD_TYPE,
    BKL_FIELD_FILE,
    BKL_FIELD_AUDIO,
    BKL_FIELD_IMAGE,
    BKL_FIELD_VIDEO,
    BKL_FIELD_BROKEN,
    BKL_FIELD_PLAYLIST,
    BKL_FIELD_EXTENDED,
} BklFieldType;

typedef enum _BklFileField {
    BKL_FILE_FIELD_URI,
    BKL_FILE_FIELD_MIMETYPE,
    BKL_FILE_FIELD_SIZE,
    BKL_FILE_FIELD_MODIFICATION_TIME
} BklFileField;

typedef enum _BklAudioField {
    BKL_AUDIO_FIELD_TITLE,
    BKL_AUDIO_FIELD_ALBUM,
    BKL_AUDIO_FIELD_ARTISTS,
    BKL_AUDIO_FIELD_PERFORMERS,
    BKL_AUDIO_FIELD_CONDUCTOR,
    BKL_AUDIO_FIELD_COMPOSER,
    BKL_AUDIO_FIELD_GENRE,
    BKL_AUDIO_FIELD_COMMENT,
    BKL_AUDIO_FIELD_COPYRIGHT,
    BKL_AUDIO_FIELD_LICENSE,
    BKL_AUDIO_FIELD_ORGANISATION,
    BKL_AUDIO_FIELD_ISRC,
    BKL_AUDIO_FIELD_CONTACT,
    BKL_AUDIO_FIELD_YEAR,
    BKL_AUDIO_FIELD_TRACK,
    BKL_AUDIO_FIELD_MAXTRACKS,
    BKL_AUDIO_FIELD_DISC,
    BKL_AUDIO_FIELD_MAXDISCS,
    BKL_AUDIO_FIELD_DURATION,
    BKL_AUDIO_FIELD_ARTIST_IMAGE
} BklAudioField;

typedef enum _BklImageField {
    BKL_IMAGE_FIELD_TITLE,
    BKL_IMAGE_FIELD_MAKE,
    BKL_IMAGE_FIELD_MODEL,
    BKL_IMAGE_FIELD_DATE,
    BKL_IMAGE_FIELD_DATE_ORIGINAL,
    BKL_IMAGE_FIELD_DATE_DIGITIZED,
    BKL_IMAGE_FIELD_ORIENTATION,
    BKL_IMAGE_FIELD_EXPOSURE,
    BKL_IMAGE_FIELD_APERTURE,
    BKL_IMAGE_FIELD_METERING_MODE,
    BKL_IMAGE_FIELD_FLASH,
    BKL_IMAGE_FIELD_ISO,
    BKL_IMAGE_FIELD_SOFTWARE,
    BKL_IMAGE_FIELD_AUTHOR,
    BKL_IMAGE_FIELD_COPYRIGHT,
    BKL_IMAGE_FIELD_COMMENT,
    BKL_IMAGE_FIELD_USER_COMMENT,
    BKL_IMAGE_FIELD_KEYWORDS,
    BKL_IMAGE_FIELD_SUBJECT,
    BKL_IMAGE_FIELD_FOCAL_LENGTH,
    BKL_IMAGE_FIELD_SHUTTER_SPEED,
    BKL_IMAGE_FIELD_WIDTH,
    BKL_IMAGE_FIELD_HEIGHT
} BklImageField;

typedef enum _BklVideoField {
    BKL_VIDEO_FIELD_TITLE,
    BKL_VIDEO_FIELD_DIRECTOR,
    BKL_VIDEO_FIELD_SERIES_NAME,
    BKL_VIDEO_FIELD_SEASON,
    BKL_VIDEO_FIELD_EPISODE,
    BKL_VIDEO_FIELD_YEAR,
    BKL_VIDEO_FIELD_DURATION,
    BKL_VIDEO_FIELD_WIDTH,
    BKL_VIDEO_FIELD_HEIGHT,
    BKL_VIDEO_FIELD_SERIES_IMAGE,
    BKL_VIDEO_FIELD_DISC
} BklVideoField;

typedef enum _BklExtendedField {
    BKL_EXTENDED_FIELD_THUMBNAIL,
    BKL_EXTENDED_FIELD_LAST_USED,
    BKL_EXTENDED_FIELD_USE_COUNT,
    BKL_EXTENDED_FIELD_RATING,
    BKL_EXTENDED_FIELD_PINNED,
    BKL_EXTENDED_FIELD_DATE_INDEXED,
    BKL_EXTENDED_FIELD_TAGS
} BklExtendedField;

typedef enum _BklBrokenField {
    BKL_BROKEN_FIELD_REASON
} BklBrokenField;

typedef enum _BklPlaylistField {
    BKL_PLAYLIST_FIELD_NAME,
    BKL_PLAYLIST_FIELD_URIS
} BklPlaylistField;

KozoField * bkl_entry_get_field (KozoEntry   *entry,
                                 BklFieldType type);
const char *bkl_file_field_get_string (KozoField   *f,
                                       BklFileField field);
const char *bkl_audio_field_get_string (KozoField    *f,
                                        BklAudioField field);
const char *bkl_image_field_get_string (KozoField    *f,
                                        BklImageField field);
const char *bkl_video_field_get_string (KozoField    *f,
                                        BklVideoField field);
const char *bkl_extended_field_get_string (KozoField       *f,
                                           BklExtendedField field);
const char *bkl_broken_field_get_string (KozoField     *f,
                                         BklBrokenField field);
const char *bkl_playlist_field_get_string (KozoField       *f,
                                           BklPlaylistField field);
G_END_DECLS

#endif
