/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_INDEXER_H__
#define __BKL_INDEXER_H__

#include "bkl-source.h"

G_BEGIN_DECLS

gboolean bkl_indexer_index_item (BklSource *source,
                                 BklItem   *item,
                                 KozoDB    *db,
                                 GError   **error);
gboolean bkl_indexer_update_item (BklSource *source,
                                  BklItem   *new_item,
                                  BklItem   *old_item,
                                  KozoDB    *db);
gboolean bkl_indexer_remove_item (BklSource *source,
                                  BklItem   *item,
                                  KozoDB    *db);

G_END_DECLS

#endif
