/*
 * Copyright (C) 2010-2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jason Smith <jason.smith@canonical.com>
 *              Marco Trevisan (Treviño) <3v1n0@ubuntu.com>
 *
 */

#ifndef __BAMFAPPLICATION_H__
#define __BAMFAPPLICATION_H__

#include "bamf.h"
#include "bamf-view.h"
#include "bamf-window.h"
#include <glib.h>
#include <glib-object.h>

#define BAMF_TYPE_APPLICATION			(bamf_application_get_type ())
#define BAMF_APPLICATION(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), BAMF_TYPE_APPLICATION, BamfApplication))
#define BAMF_IS_APPLICATION(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAMF_TYPE_APPLICATION))
#define BAMF_APPLICATION_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), BAMF_TYPE_APPLICATION, BamfApplicationClass))
#define BAMF_IS_APPLICATION_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), BAMF_TYPE_APPLICATION))
#define BAMF_APPLICATION_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), BAMF_TYPE_APPLICATION, BamfApplicationClass))

typedef struct _BamfApplication BamfApplication;
typedef struct _BamfApplicationClass BamfApplicationClass;
typedef struct _BamfApplicationPrivate BamfApplicationPrivate;

struct _BamfApplicationClass
{
  BamfViewClass parent;
};

struct _BamfApplication
{
  BamfView parent;

  /* private */
  BamfApplicationPrivate *priv;
};

GType             bamf_application_get_type                   (void) G_GNUC_CONST;

const char      * bamf_application_get_desktop_file           (BamfApplication *application);
void              bamf_application_set_desktop_file           (BamfApplication *application,
                                                               const char * desktop_file);

GVariant        * bamf_application_get_xids                   (BamfApplication *application);

gboolean          bamf_application_manages_xid                (BamfApplication *application,
                                                               guint32 xid);

gboolean          bamf_application_contains_similar_to_window (BamfApplication *app, 
                                                               BamfWindow *window);

const char      * bamf_application_get_wmclass                (BamfApplication *application);
void              bamf_application_set_wmclass                (BamfApplication *application,
                                                               const char *wmclass);

BamfApplication * bamf_application_new                        (void);

BamfApplication * bamf_application_new_from_desktop_file      (const char * desktop_file);
gboolean          bamf_application_get_show_stubs             (BamfApplication *application);

BamfApplication * bamf_application_new_from_desktop_files     (GList * desktop_files);

BamfApplication * bamf_application_new_with_wmclass           (const char *wmclass);

#endif
