<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    forums.php                                              */
/* Author:      Mark Kessell                                            */
/* Description: Forums page                                             */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("forum-defs.php");
include_once("selfregistration-defs.php");
include_once("mail-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Axyl Forums", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);

// -----------------------------------------------------------------------------------------------

debugbr("regmode is: $regmode");
if ( trim($regmode) != "" && trim($CancelReg_x) == "" ) {
  $reguser = new user_self_registration('t', trim($regmode), $user_id, "Axyl Forums", "mark@catalyst.net.nz");

  // MAIN CONTENT
  $RESPONSE->plugin("MAIN_CONTENT", $reguser->render());
} else {
  $forum = new forum($forum_id);

  // set the forum title
  if ( $RESPONSE->ismemberof_group_in("Guest") ) {
    $link = "<a href=\"?regmode=newreg\">Please Register</a>";
  } else {
    $link = "<a href=\"?regmode=editreg&user_id=$RESPONSE->userid\">Edit Registration Details</a>";
  }
  $forum->set_forum_greeting("Welcome to the AXYL Forums.<br>$link");


  // MAIN CONTENT
  $RESPONSE->plugin("MAIN_CONTENT", $forum->render());
}
if ($RESPONSE->microsite_detected != "") {
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
}


// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>