/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

import java.io.IOException;

import nz.net.catalyst.Log;
import nz.net.catalyst.Main;
import nz.net.catalyst.SocketListener;

//Only needed it using the thread pooling classes.
//import com.holub.asynch.Socket_server;

/**
 * Lucene Server main entry point.  <p>
 *
 * As a sub-class of {@link Main}, this will read in the Server.config
 * (if it exists) for a list of start-up classes (default: this class)
 * and then will execute those classes' Start(String[]) method. <p>
 *
 * I (Hamish) have changed the start method to use a normal class rather than an
 * anonomous class.  I have also expanded some lines to make them more readable
 * (IMHO).
 * @see nz.net.catalyst.SocketListener
 */

public class Server extends Main implements IPackage, Constants
{
  private static final Server instance = new Server();
  public  static final int LISTENER_PORT = 22222;
  private static final String PORT_PROPERTY = PACKAGE + "port";
  private static SocketListener listener;

  //public static nz.net.catalyst.lucene.cache.IndexSearcherCache isc = new nz.net.catalyst.lucene.cache.IndexSearcherCache(new java.io.File("/lucene/test/index"));
  /**
   * Read config file and start the system.
   */
  public static void main(String args[])
  {
    // Force the use of just a linefeed as a output line terminator.
    // This may not work, depending on how tricky Java gets.
    System.setProperty("line.terminator", new String(new char[]{12}));

    instance.init(args);
  }

  /**
   * Called by startup sequence.  Invoke a TCP Socket listener and
   * await connections.  Each connection will activate a new thread
   * under the control of a {@link Session} instance.
   *
   * @param args Command line parameters (currently ignored).
   */
  public static void Start(String[] args) throws Exception {
    //get the port
    int port = Integer.getInteger(PORT_PROPERTY, LISTENER_PORT).intValue();
    
    String sMsg = "LuceneServer Version " + LSD_VERSION + " starting up on port " + port; 
    Log.info(sMsg);
    System.err.println(sMsg + " at " + new java.util.Date() );  
    
    listener = new SocketListener(port, null);
    
    try {
      //bind listener to the socket.
      listener.bind();
    }
    catch (IOException e) {
      String eMsg = "error: unable to bind socket to port " + port + " on server startup"; 
      Log.error(eMsg);
      System.err.println(eMsg + " at " + new java.util.Date() );  
      throw new RuntimeException(eMsg, e);
    }

    //start the listener thread to listen for incoming connections
    listener.startListener();
  }


}
