# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import QWebView
from PyQt4 import uic
from PyKDE4.kdeui import *
from PyKDE4.kdecore import *

import subprocess
from tempfile import NamedTemporaryFile

import os
import os.path

import time
import thread
import apt_pkg

from AptUrl.UI import AbstractUI
from AptUrl import Helpers
from AptUrl.Helpers import utf8, _, _n

class AptUrlDialog(KDialog):
    def __init__(self,parent=None):
        KDialog.__init__(self,parent)
        self.setWindowIcon(KIcon("application-x-deb"))

    def slotButtonClicked(self,button):
        if button in (KDialog.Apply, KDialog.Ok, KDialog.Yes):
            KDialog.accept(self)
        else:
            KDialog.reject(self)

class KdeUI(AbstractUI):
    def __init__(self):
        self.dialog = AptUrlDialog()

        self.d = QWidget(self.dialog)
        self.dialog.setMainWidget(self.d)

        uic.loadUi('/usr/share/apturl/apturl.ui', self.d)
        self.d.image_label.setPixmap(KIcon("application-x-deb").pixmap(64,64))

    # generic dialogs
    def _get_dialog(self, dialog_type, summary, msg="", buttons=KDialog.Close):
        self.dialog.setButtons(KDialog.ButtonCode(buttons))
        self.d.header_label.setText("<h2>" + summary + "</h2>")
        self.d.body_label.setText(msg)
        # TODO: title = empty
        # TODO: keep above maintain across events
        # TODO: d.set_markup("<big><b>%s</b></big>\n\n%s" % (summary, msg))

    def error(self, summary, msg=""):
        if msg != "":
            KMessageBox.detailedError(AptUrlDialog(), summary, msg)
        else:
            KMessageBox.error(AptUrlDialog(), summary)
        return False

    def message(self, summary, msg="", title=""):
        if msg != "":
            summary += "\n\n" + msg
        KMessageBox.information(AptUrlDialog(), summary, title)
        return True

    def yesNoQuestion(self, summary, msg, title="", default='no'):
        self._get_dialog('', summary, msg,
                             buttons=KDialog.Yes | KDialog.No)
        self.d.setWindowTitle(title)
        res = self.dialog.exec_()
        if res != KDialog.Accepted:
            return False
        return True

    # specific dialogs
    def askEnableChannel(self, channel, channel_info_html):
        summary = "<h2>" + _("Enable additional software channel") + "</h2>"
        msg = _("Do you want to enable the following "
                "software channel: '%s'?") % channel
        self._get_dialog('', summary, msg,
                             buttons=KDialog.Yes | KDialog.No)
        webview = QWebView()
        webview.setHtml(channel_info_html)
        webview.setFixedSize(400,200)
        self.d.vlayout_right.addWidget(webview)
        res = self.dialog.exec_()
        if res != KDialog.Accepted:
            return False
        return True

    def doEnableSection(self, sections):
        cmd = ["kdesudo",
               "--",
               "software-properties-kde",
               "--enable-component", "%s" % ' '.join(sections)]
        try:
            output = subprocess.Popen(cmd, stdout=subprocess.PIPE).communicate()[0]
        except OSError, e:
            print >>sys.stderr, "Execution failed:", e
            return True
        # FIXME: Very ugly, but kdesudo doesn't return the correct exit states
        print output
        if not output.startswith("Enabled the "):
            return False
        return True


    def doEnableChannel(self, channelpath, channelkey):
        cmd = ["kdesudo",
               "--",
               "install", "--mode=644","--owner=0",channelpath,
               apt_pkg.Config.FindDir("Dir::Etc::sourceparts")]
        res=subprocess.call(cmd)
        if not res == 0:
            return False
        # install the key as well
        if os.path.exists(channelkey):
            cmd = ["kdesudo",
                   "--",
                   "apt-key", "add",channelkey]
            res=subprocess.call(cmd)
            if not res == 0:
                return False
        return True

    def askInstallPackage(self, package, summary, description, homepage):
        header = "<h2>" + _("Install additional software?") + "</h2>"
        body = _("Do you want to install package '%s'?") % package
        desc = "%s\n\n%s" % (summary, Helpers.format_description(description))

        self.d.header_label.setText(header)
        self.d.body_label.setText(body)
        #self.description_edit.show()
        #self.description_edit.setText(desc)

        self.dialog.setButtons(KDialog.ButtonCode(KDialog.Yes | KDialog.No))

        res = self.dialog.exec_()
        if res != KDialog.Accepted:
            return False
        return True

    # progress etc
    def doUpdate(self):
        p = subprocess.Popen(['kdesudo',
                              '--attach', str(self.dialog.winId()),
                              '--',
                              'install-package',
                              '--attach', str(self.dialog.winId()),
                              '--update'
                              ])
        self._wait_for_install_package(p)

    def doInstall(self, apturl):
        p = subprocess.Popen(['kdesudo',
                              '--attach', str(self.dialog.winId()),
                              '--',
                              'install-package',
                              '--attach', str(self.dialog.winId()),
                              '--install',
                              apturl.package
                              ])
        self._wait_for_install_package(p)
        return True

    # helpers
    def _wait_for_p(self, p, lock):
        " helper for the thread to wait for process p to finish "
        p.wait()
        lock.release()

    def _wait_for_install_package(self, p):
        # wait for install-package
        lock = thread.allocate_lock()
        lock.acquire()
        thread.start_new_thread(self._wait_for_p, (p, lock))

        while lock.locked():
            time.sleep(0.01)
        return True


if __name__ == "__main__":
    ui = KdeUI()
    ui.error("foo","bar")

# kate: space-indent on; indent-width 4; mixedindent off; indent-mode python;
