#!/usr/bin/python

import sys
sys.path.insert(0, "../")

import unittest
from AptUrl.Helpers import parse_pkg

class MockPkg(object):
    def __init__(self, descr):
        self.description = descr
        self.homepage = None

class testHelpers(unittest.TestCase):

    def test_parse_pkg(self):
        pkgobj = MockPkg("summary\ndescr\n")
        self.assert_(parse_pkg(pkgobj) == ('summary','descr\n',None))
        pkgobj = MockPkg("summary only")
        self.assert_(parse_pkg(pkgobj) == ('summary only','',None))

if __name__ == "__main__":
    unittest.main()

