//#include <stdio.h>
#include <rechecks.h>

#define LOCAL_DEBUG
#include "debug.h"

#include "acfg.h" 

rechecks::rechecks() : m_nErrors(0) {
	//printf("%s\n%s\n", a, b);
    
    int rc = regcomp(&rePfiles, acfg::pfilepat.c_str(), REG_EXTENDED);
    m_nErrors+=(rc!=0);
        
    rc=regcomp(&reIfiles, acfg::vfilepat.c_str(), REG_EXTENDED);
    m_nErrors+=(rc!=0);
        
    //ldbg("reIfiles: " << rc);
    //rc=regcomp(&rePoison, "[^a-zA-Z0-9\\-+_~./]", REG_EXTENDED);
    //rc=regcomp(&rePoison, "[^a-zA-Z0-9._~+/-]", REG_EXTENDED);
    //ldbg("rePoison: " << rc);
    ASSERT(!rc);
}

rechecks::~rechecks() {
    //regfree(&rePoison);
    regfree(&reIfiles);
    regfree(&rePfiles);
    
}

rechecks::eFileKind rechecks::getFiletype(const char *in) {
    dbgline;
    if(!regexec(&rePfiles, in, 0, NULL, 0))
        return FILE_PKG;
    dbgline;
    if(!regexec(&reIfiles, in, 0, NULL, 0))
        return FILE_INDEX;
    dbgline;
    return FILE_INVALID;
}

bool rechecksEx::IsInWhitelist(const char *s)
{
	return (!regexec(&reWfiles, s, 0, NULL, 0));
}

rechecksEx::rechecksEx()
{
   	m_nErrors+=(0!=regcomp(&reWfiles, acfg::wfilepat.c_str(), REG_EXTENDED));    
}
rechecksEx::~rechecksEx()
{
	regfree(&reWfiles); 
}

/*
int main(int argc, char **argv) {
    rechecks checka;
    printf("re: typ von %s ist %d\n", argv[1], checka.getFiletype(argv[1]));
}
*/
