#!/usr/bin/perl
#
open(fdd, ">conf/deb_mirrors") || die;
open(fdv, ">conf/debvol_mirrors") || die;

while(<>)
{
   chomp;
   s/^\s+//;
   s/\s+$//;
   next if /^#/;
   if(/(\S+)\s*:\s*(\S+)/)
   {
      $key=$1;
      $value=$2;
      #print "moo, $key -> $val\n";

      if($key eq "Site" || $key eq "Alias" || $key eq "Includes" || $key eq "Aliases")
      {
         push(@hosts, split(/\s/, $value));
      }
      if($key eq "Archive-http" || $key eq "X-Archive-http")
      {
         push(@pathsdeb, $value);
      }
      if($key eq "Volatile-http" || $key eq "X-Volatile-http")
      {
         push(@pathsvol, $value);
      }
   }
   elsif(@hosts)
   {
      foreach $h (@hosts)
      {
         foreach $pd (@pathsdeb)
         {
            print fdd "http://$h$pd\n";
         }
         foreach $pd (@pathsvol)
         {
            print fdv "http://$h$pd\n";
         }
      }
      undef @hosts;
      undef @pathsdeb;
      undef @pathsvol;
   }

}

close(fdd) || die;
close(fdv) || die;
