/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-project.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-project
 * @title: IAnjutaProject
 * @short_description: Interface implemented by project backend
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-project-backend.h
 * 
 * This is the new interface that is replacing Gnome Build.
 */

#include "ianjuta-project.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_project_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-quark");
	}
	
	return quark;
}

/**
* ianjuta_project_add_group:
* @obj: Self
* @parent: parent group
* @name: new group name
* @err: Error propagation and reporting.
*
* Create a new group, parent can be NULL.
*
* Returns: The new group or NULL on error.
*/
AnjutaProjectGroup*
ianjuta_project_add_group (IAnjutaProject *obj, AnjutaProjectGroup *parent,   const gchar *name, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	g_return_val_if_fail ((parent == NULL) ||ANJUTA_IS_PROJECT_GROUP(parent), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->add_group (obj, parent, name, err);
}

/* Default implementation */
static AnjutaProjectGroup*
ianjuta_project_add_group_default (IAnjutaProject *obj, AnjutaProjectGroup *parent,   const gchar *name, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_add_source:
* @obj: Self
* @parent: parent target
* @file: source file
* @err: Error propagation and reporting.
*
* Create a new source, parent cannot be NULL
*
* Returns: The new source or NULL on error.
*/
AnjutaProjectSource*
ianjuta_project_add_source (IAnjutaProject *obj, AnjutaProjectTarget *parent,   GFile *file, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	g_return_val_if_fail ((parent == NULL) ||ANJUTA_IS_PROJECT_TARGET(parent), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->add_source (obj, parent, file, err);
}

/* Default implementation */
static AnjutaProjectSource*
ianjuta_project_add_source_default (IAnjutaProject *obj, AnjutaProjectTarget *parent,   GFile *file, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_add_target:
* @obj: Self
* @parent: parent group
* @name: new target name
* @type: new target type
* @err: Error propagation and reporting.
*
* Create a new target, parent cannot be NULL
*
* Returns: The new target or NULL on error.
*/
AnjutaProjectTarget*
ianjuta_project_add_target (IAnjutaProject *obj, AnjutaProjectGroup *parent,   const gchar *name,   AnjutaProjectTargetType type, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	g_return_val_if_fail ((parent == NULL) ||ANJUTA_IS_PROJECT_GROUP(parent), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->add_target (obj, parent, name, type, err);
}

/* Default implementation */
static AnjutaProjectTarget*
ianjuta_project_add_target_default (IAnjutaProject *obj, AnjutaProjectGroup *parent,   const gchar *name,   AnjutaProjectTargetType type, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_configure:
* @obj: Self
* @err: Error propagation and reporting.
*
* Return a widget that can be use to set any options needed by the project
*
* Returns: A GtkWidget
*/
GtkWidget*
ianjuta_project_configure (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->configure (obj, err);
}

/* Default implementation */
static GtkWidget*
ianjuta_project_configure_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_configure_node:
* @obj: Self
* @node: node to configure
* @err: Error propagation and reporting.
*
* Return a widget that can be use to set any options needed by this node
*
* Returns: A GtkWidget
*/
GtkWidget*
ianjuta_project_configure_node (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	g_return_val_if_fail ((node == NULL) ||ANJUTA_IS_PROJECT_NODE(node), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->configure_node (obj, node, err);
}

/* Default implementation */
static GtkWidget*
ianjuta_project_configure_node_default (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_get_capabilities:
* @obj: Self
* @err: Error propagation and reporting.
*
* Returns the capabilites of project whether it can add group, target
* sources etc.
*
* Returns: Supported capabilites.
*/
guint
ianjuta_project_get_capabilities (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), 0);
	return IANJUTA_PROJECT_GET_IFACE (obj)->get_capabilities (obj, err);
}

/* Default implementation */
static guint
ianjuta_project_get_capabilities_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/*
 * ianjuta_project_get_packages
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: the list of pkg-config packages that the current project
 * requires in it's configure.ac. Can be NULL if there is no project
 * opened currently or no package is required.
 */
GList*
ianjuta_project_get_packages (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), 0);
	return IANJUTA_PROJECT_GET_IFACE (obj)->get_packages (obj, err);
}

/* Default implementation */
static GList*
ianjuta_project_get_packages_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_project_get_root:
* @obj: Self
* @err: Error propagation and reporting.
*
* Get the root node of the project (always a group)
*
* Returns: The new group or NULL on error.
*/
AnjutaProjectGroup*
ianjuta_project_get_root (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), NULL);
	return IANJUTA_PROJECT_GET_IFACE (obj)->get_root (obj, err);
}

/* Default implementation */
static AnjutaProjectGroup*
ianjuta_project_get_root_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/*
 * ianjuta_project_get_target_types
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: the list of supported target types
 */
GList*
ianjuta_project_get_target_types (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), 0);
	return IANJUTA_PROJECT_GET_IFACE (obj)->get_target_types (obj, err);
}

/* Default implementation */
static GList*
ianjuta_project_get_target_types_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_project_load:
 * @obj: Self
 * @file: Project directory
 * @err: Error propagation and reporting
 *
 * Load a project
 *
 * Return value: TRUE is loaded without errors
 */
gboolean
ianjuta_project_load (IAnjutaProject *obj, GFile *file, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), FALSE);
	return IANJUTA_PROJECT_GET_IFACE (obj)->load (obj, file, err);
}

/* Default implementation */
static gboolean
ianjuta_project_load_default (IAnjutaProject *obj, GFile *file, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_project_refresh:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Reload the current project
 *
 * Return value: TRUE is loaded without errors
 */
gboolean
ianjuta_project_refresh (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), FALSE);
	return IANJUTA_PROJECT_GET_IFACE (obj)->refresh (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_project_refresh_default (IAnjutaProject *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_project_remove_node:
* @obj: Self
* @node: node to configure
* @err: Error propagation and reporting.
*
* Remove a node (a group, a target or a source) from the project.
*
* Returns: TRUE if the node has been removed
*/
gboolean
ianjuta_project_remove_node (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_PROJECT(obj), FALSE);
	g_return_val_if_fail ((node == NULL) ||ANJUTA_IS_PROJECT_NODE(node), FALSE);
	return IANJUTA_PROJECT_GET_IFACE (obj)->remove_node (obj, node, err);
}

/* Default implementation */
static gboolean
ianjuta_project_remove_node_default (IAnjutaProject *obj, AnjutaProjectNode *node, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_project_base_init (IAnjutaProjectIface* klass)
{
	static gboolean initialized = FALSE;

	klass->add_group = ianjuta_project_add_group_default;
	klass->add_source = ianjuta_project_add_source_default;
	klass->add_target = ianjuta_project_add_target_default;
	klass->configure = ianjuta_project_configure_default;
	klass->configure_node = ianjuta_project_configure_node_default;
	klass->get_capabilities = ianjuta_project_get_capabilities_default;
	klass->get_packages = ianjuta_project_get_packages_default;
	klass->get_root = ianjuta_project_get_root_default;
	klass->get_target_types = ianjuta_project_get_target_types_default;
	klass->load = ianjuta_project_load_default;
	klass->refresh = ianjuta_project_refresh_default;
	klass->remove_node = ianjuta_project_remove_node_default;
	
	if (!initialized) {

		/* Signals */
		/**
		* IAnjutaProject::project_updated:
		* @obj: Self
		* 
		* This signal is emitted when the project is changed.
		*/
		g_signal_new ("project-updated",
			IANJUTA_TYPE_PROJECT,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaProjectIface, project_updated),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		initialized = TRUE;
	}
}

GType
ianjuta_project_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaProjectIface),
			(GBaseInitFunc) ianjuta_project_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaProject", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_project_capabilities_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_CAN_ADD_NONE, "IANJUTA_PROJECT_CAN_ADD_NONE", "can-add-none" }, 
		{ IANJUTA_PROJECT_CAN_ADD_GROUP, "IANJUTA_PROJECT_CAN_ADD_GROUP", "can-add-group" }, 
		{ IANJUTA_PROJECT_CAN_ADD_TARGET, "IANJUTA_PROJECT_CAN_ADD_TARGET", "can-add-target" }, 
		{ IANJUTA_PROJECT_CAN_ADD_SOURCE, "IANJUTA_PROJECT_CAN_ADD_SOURCE", "can-add-source" }, 
		{ IANJUTA_PROJECT_HAS_PACKAGES, "IANJUTA_PROJECT_HAS_PACKAGES", "has-packages" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectCapabilities", values);
	}

	return type;
}

GType
ianjuta_project_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_ERROR_SUCCESS, "IANJUTA_PROJECT_ERROR_SUCCESS", "error-success" }, 
		{ IANJUTA_PROJECT_ERROR_DOESNT_EXIST, "IANJUTA_PROJECT_ERROR_DOESNT_EXIST", "error-doesnt-exist" }, 
		{ IANJUTA_PROJECT_ERROR_ALREADY_EXISTS, "IANJUTA_PROJECT_ERROR_ALREADY_EXISTS", "error-already-exists" }, 
		{ IANJUTA_PROJECT_ERROR_VALIDATION_FAILED, "IANJUTA_PROJECT_ERROR_VALIDATION_FAILED", "error-validation-failed" }, 
		{ IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED, "IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED", "error-project-malformed" }, 
		{ IANJUTA_PROJECT_ERROR_GENERAL_FAILURE, "IANJUTA_PROJECT_ERROR_GENERAL_FAILURE", "error-general-failure" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectError", values);
	}

	return type;
}

GType
ianjuta_project_probe_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_PROBE_FILES, "IANJUTA_PROJECT_PROBE_FILES", "probe-files" }, 
		{ IANJUTA_PROJECT_PROBE_MAKE_FILES, "IANJUTA_PROJECT_PROBE_MAKE_FILES", "probe-make-files" }, 
		{ IANJUTA_PROJECT_PROBE_PROJECT_FILES, "IANJUTA_PROJECT_PROBE_PROJECT_FILES", "probe-project-files" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectProbe", values);
	}

	return type;
}
