/*
 * Copyright (C) 2010 Motorola
 * Copyright (C) 2011-2012 Canonical, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define LOG_NDEBUG 0
#define LOG_TAG "AndroidAudioWrapper"

#include <waudio/android_audio_wrapper_define.h>
#include <utils/Log.h>
#include <stdio.h>
#include "media/AudioTrack.h"
#include "media/AudioRecord.h"
#include "media/AudioSystem.h"
using namespace android;

extern "C" 
{

TrackHandle CreateAudioTrack()
{
    LOGV("Enter CreateAudioTrack");
    AudioTrack* lpTrack = new AudioTrack();

    if (lpTrack == NULL)
    {
        LOGV("Error creating uninitialized AudioTrack");
        return NULL; 
    }
    LOGV("create AudioTrack successfully");
	return (TrackHandle)lpTrack;
}

status_type AudioTrack_set(TrackHandle handle,stream_type streamtype, uint32 samplerate,audio_format format, audio_channels channel)
{
    status_type result = INVALID_PARAM;
    status_t andrresult;

    LOGV("Enter AudioTrack_set and streamtype is %d, samplerate is %d, audioformat is %d, audiochannels is %d.", (int)streamtype, (int)samplerate, (int)format, (int)channel);

    if (handle != NULL)
    {
        andrresult = static_cast<AudioTrack*>(handle)->set(streamtype,samplerate,format,channel);
        result = (status_type)andrresult; 
        LOGV("Call AudioTrack set and result is %d", andrresult);
    }
    else
    {
	    LOGV("Handle is invalid and does not call AudioTrack set");
    }
    return result;
}

status_type AudioTrack_set_asyn(TrackHandle handle,stream_type streamtype, uint32 samplerate,audio_format format, audio_channels channel,callback_t cbf,void* user)
{
    status_type result = INVALID_PARAM;
    status_t andrresult;

    LOGV("Enter AudioTrack_set and streamtype is %d, samplerate is %d, audioformat is %d, audiochannels is %d.", (int)streamtype, (int)samplerate, (int)format, (int)channel);

    if (handle != NULL)
    {
        andrresult = static_cast<AudioTrack*>(handle)->set(streamtype,samplerate,format,channel,0,0,cbf,user);
        result = (status_type)andrresult;
        LOGV("Call AudioTrack set and result is %d", andrresult);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack set asyn");
    }
    return result;
    }

void AudioTrack_start(TrackHandle handle)
{
    LOGV("Enter AudioTrack_start");
    if (handle != NULL)
    {
        static_cast<AudioTrack*>(handle)->start();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack start");
    }
}

void AudioTrack_stop(TrackHandle handle)
{
    LOGV("Enter AudioTrack_stop");	
    if (handle != NULL)
    {   
        static_cast<AudioTrack*>(handle)->stop();
    }
    else
    {   
        LOGV("Handle is invalid and does not call AudioTrack stop");
    } 
}

status_type AudioTrack_getposition(TrackHandle handle,uint32 *position)
{
    LOGV("Enter AudioTrack_getposition");	
    status_type result = INVALID_PARAM;
    status_t andrresult;

    if (handle != NULL && position != NULL)
    {
        andrresult = static_cast<AudioTrack*>(handle)->getPosition((uint32_t*)position);
        result = (status_type)andrresult;
        LOGV("Call AudioTrack getPosition and result is %d, position=%d.", (int)andrresult,(int) *position);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack getPosition");
    }
    return result;
}

size_t AudioTrack_write(TrackHandle handle,const void *buffer, size_t size)
{
    LOGV("Enter AudioTrack_write and size is %d.", size);	
    size_t result = 0;

    if (handle != NULL && buffer != NULL && size > 0)
    {
        result = static_cast<AudioTrack*>(handle)->write(buffer,size);
        LOGV("Call AudioTrack write and result is %d.",result);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack write");
    }
    return result;
}

void AudioTrack_pause(TrackHandle handle)
{
    LOGV("Enter AudioTrack_pause");	
    if (handle != NULL )
    {
        static_cast<AudioTrack*>(handle)->pause();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack pause");
    }
}

uint32 AudioTrack_latency(TrackHandle handle)
{
    LOGV("Enter AudioTrack_latency");	
    uint32 result = 0;
    if (handle != NULL)
    {
        result = static_cast<AudioTrack*>(handle)->latency();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack latency");
    }
    return result;
}

void AudioTrack_mute(TrackHandle handle, int muted)
{
    LOGV("Enter AudioTrack_mute");
    if ( handle != NULL )
    {
        static_cast<AudioTrack*>(handle)->mute(muted);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioTrack mute");
    }
    return;
}

void DestoryAudioTrack(TrackHandle handle)
{
    LOGV("Enter DestoryAudioTrack");	
    if ( handle != NULL )
    {
        delete static_cast<AudioTrack*>(handle);
        LOGV("Delete AudioTrack successfully");
    }
    else
    {
        LOGV("Handle is invalid and does not delete AudioTrack");
    }
}


/*Audio Record related interface*/
RecordHandle CreateAudioRecord()
{
    LOGV("Enter CreateAudioRecord");	
    AudioRecord* lpRecord = new AudioRecord();

    if (lpRecord == NULL)
    {
        LOGV("Error creating uninitialized AudioRecord");
        return NULL;
    }
    LOGV("create AudioRecord successfully");
    return (RecordHandle)lpRecord;
}

void DestoryAudioRecord(RecordHandle handle)
{
    LOGV("Enter DestoryAudioRecord");	
    if (handle != NULL )
    {
        delete static_cast<AudioTrack*>(handle);
        LOGV("Delete AudioRecord successfully");
    }
    else
    {
        LOGV("Handle is invalid and does not deletel AudioRecord ");
    }
}

void AudioRecord_start(RecordHandle handle)
{
    LOGV("Enter AudioRecord_start");	
    if (handle != NULL )
    {
        static_cast<AudioRecord*>(handle)->start();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord start");
    }
}

void AudioRecord_stop(RecordHandle handle)
{
    LOGV("Enter AudioRecord_stop");	
    if ( handle != NULL )
    {
        static_cast<AudioRecord*>(handle)->stop();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord stop");
    }
}

status_type AudioRecord_getposition(RecordHandle handle,int32_t *position)
{
    LOGV("Enter AudioRecord_getposition");	
    status_type result = INVALID_PARAM;
    status_t andrresult;

    if ( handle != NULL && position != NULL )
    {
        andrresult = static_cast<AudioRecord*>(handle)->getPosition((uint32_t*)position);
        result = (status_type)andrresult;
        LOGV("Call AudioRecord getPosition and result is %d, position=%d.", andrresult, *position);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord getPosition");
    }
    return result;
}

size_t AudioRecord_read(RecordHandle handle,void *buffer, size_t size)
{
    LOGV("Enter AudioRecord_read and size is %d.", size);	
    size_t result = 0;

    if (handle != NULL && buffer != NULL && size > 0)
    {
        result = static_cast<AudioRecord*>(handle)->read(buffer,size);
        LOGV("Call AudioRecored read and result is %d.", result);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord read");
    }
    return result;
}

status_type AudioRecord_set(RecordHandle handle,audio_source_t inputsource)
{
    LOGV("Enter AudioRecord_set and audiosource is %d.", inputsource);	
    status_type result = INVALID_PARAM;
    status_t andrresult;

    if (handle != NULL)
    {
        andrresult = static_cast<AudioRecord*>(handle)->set(inputsource);
        result = (status_type)andrresult;
        LOGV("Call AudioRecord set and result is %d", andrresult);
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord set");
    }
    return result;
}

uint32 AudioRecord_latency(RecordHandle handle)
{
    LOGV("Enter AudioRecord_latency");
    uint32 result = 0;
    if (handle != NULL)
    {
        result = static_cast<AudioRecord*>(handle)->latency();
    }
    else
    {
        LOGV("Handle is invalid and does not call AudioRecord latency");
    }
    return result;
}

/*Audio System related interface*/
status_type AudioSystem_getStreamVolumeIndex(stream_type streamtype,int *index )
{
    LOGV(">> AudioSystem_getStreamVolumeIndex: streamtype is %d.", streamtype);
    return AudioSystem::getStreamVolumeIndex(static_cast<audio_stream_type_t>(streamtype), index);
}

status_type AudioSystem_getStreamMute(stream_type  streamtype, int *mute )
{
    LOGV(">> AudioSystem_getStreamMute: streamtype is %d.",streamtype);
    return AudioSystem::getStreamMute(static_cast<audio_stream_type_t>(streamtype), (bool*)mute);
}

status_type AudioSystem_setStreamVolumeIndex(stream_type streamtype,int index )
{
    LOGV(">> AudioSystem_setStreamVolumeIndex:streamtype is %d.",streamtype);
    return AudioSystem::setStreamVolumeIndex(static_cast<audio_stream_type_t>(streamtype), index);
}

status_type AudioSystem_setStreamMute(stream_type streamtype, int mute )
{
    LOGV(">> AudioSystem_setStreamMute:streamtype is %d.", streamtype);
    return AudioSystem::setStreamMute(static_cast<audio_stream_type_t>(streamtype), mute);
}

} // extern "C"


