#ifndef __eglext_h_
#define __eglext_h_

#ifdef __cplusplus
extern "C" {
#endif

/*
** Copyright (c) 2007-2008 The Khronos Group Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and/or associated documentation files (the
** "Materials"), to deal in the Materials without restriction, including
** without limitation the rights to use, copy, modify, merge, publish,
** distribute, sublicense, and/or sell copies of the Materials, and to
** permit persons to whom the Materials are furnished to do so, subject to
** the following conditions:
**
** The above copyright notice and this permission notice shall be included
** in all copies or substantial portions of the Materials.
**
** THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
** EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
** MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
** IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
** CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
** TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
** MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
*/
#if defined(ANDROID)
#include "../../include/public/EGL/eglplatform.h"
#else
#include <EGL/eglplatform.h>
#endif

/*************************************************************/

/* Header file version number */
/* eglext.h last updated 2008/11/25 */
/* Current version at http://www.khronos.org/registry/egl/ */
#define EGL_EGLEXT_VERSION 3

#ifndef EGL_KHR_config_attribs
#define EGL_KHR_config_attribs 1
#define EGL_CONFORMANT_KHR          0x3042  /* EGLConfig attribute */
#define EGL_VG_COLORSPACE_LINEAR_BIT_KHR    0x0020  /* EGL_SURFACE_TYPE bitfield */
#define EGL_VG_ALPHA_FORMAT_PRE_BIT_KHR     0x0040  /* EGL_SURFACE_TYPE bitfield */
#endif

#ifndef EGL_KHR_lock_surface
#define EGL_KHR_lock_surface 1
#define EGL_READ_SURFACE_BIT_KHR        0x0001  /* EGL_LOCK_USAGE_HINT_KHR bitfield */
#define EGL_WRITE_SURFACE_BIT_KHR       0x0002  /* EGL_LOCK_USAGE_HINT_KHR bitfield */
#define EGL_LOCK_SURFACE_BIT_KHR        0x0080  /* EGL_SURFACE_TYPE bitfield */
#define EGL_OPTIMAL_FORMAT_BIT_KHR      0x0100  /* EGL_SURFACE_TYPE bitfield */
#define EGL_MATCH_FORMAT_KHR            0x3043  /* EGLConfig attribute */
#define EGL_FORMAT_RGB_565_EXACT_KHR        0x30C0  /* EGL_MATCH_FORMAT_KHR value */
#define EGL_FORMAT_RGB_565_KHR          0x30C1  /* EGL_MATCH_FORMAT_KHR value */
#define EGL_FORMAT_RGBA_8888_EXACT_KHR      0x30C2  /* EGL_MATCH_FORMAT_KHR value */
#define EGL_FORMAT_RGBA_8888_KHR        0x30C3  /* EGL_MATCH_FORMAT_KHR value */
#define EGL_MAP_PRESERVE_PIXELS_KHR     0x30C4  /* eglLockSurfaceKHR attribute */
#define EGL_LOCK_USAGE_HINT_KHR         0x30C5  /* eglLockSurfaceKHR attribute */
#define EGL_BITMAP_POINTER_KHR          0x30C6  /* eglQuerySurface attribute */
#define EGL_BITMAP_PITCH_KHR            0x30C7  /* eglQuerySurface attribute */
#define EGL_BITMAP_ORIGIN_KHR           0x30C8  /* eglQuerySurface attribute */
#define EGL_BITMAP_PIXEL_RED_OFFSET_KHR     0x30C9  /* eglQuerySurface attribute */
#define EGL_BITMAP_PIXEL_GREEN_OFFSET_KHR   0x30CA  /* eglQuerySurface attribute */
#define EGL_BITMAP_PIXEL_BLUE_OFFSET_KHR    0x30CB  /* eglQuerySurface attribute */
#define EGL_BITMAP_PIXEL_ALPHA_OFFSET_KHR   0x30CC  /* eglQuerySurface attribute */
#define EGL_BITMAP_PIXEL_LUMINANCE_OFFSET_KHR   0x30CD  /* eglQuerySurface attribute */
#define EGL_LOWER_LEFT_KHR          0x30CE  /* EGL_BITMAP_ORIGIN_KHR value */
#define EGL_UPPER_LEFT_KHR          0x30CF  /* EGL_BITMAP_ORIGIN_KHR value */
#ifdef EGL_EGLEXT_PROTOTYPES
EGLAPI EGLBoolean EGLAPIENTRY eglLockSurfaceKHR (EGLDisplay display, EGLSurface surface, const EGLint *attrib_list);
EGLAPI EGLBoolean EGLAPIENTRY eglUnlockSurfaceKHR (EGLDisplay display, EGLSurface surface);
#endif /* EGL_EGLEXT_PROTOTYPES */
typedef EGLBoolean (EGLAPIENTRYP PFNEGLLOCKSURFACEKHRPROC) (EGLDisplay display, EGLSurface surface, const EGLint *attrib_list);
typedef EGLBoolean (EGLAPIENTRYP PFNEGLUNLOCKSURFACEKHRPROC) (EGLDisplay display, EGLSurface surface);
#endif

#ifndef EGL_KHR_image
#define EGL_KHR_image 1
#define EGL_NATIVE_PIXMAP_KHR           0x30B0  /* eglCreateImageKHR target */
typedef void *EGLImageKHR;
#define EGL_NO_IMAGE_KHR			((EGLImageKHR)0)
#ifdef EGL_EGLEXT_PROTOTYPES
EGLAPI EGLImageKHR EGLAPIENTRY eglCreateImageKHR (EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint *attrib_list);
EGLAPI EGLBoolean EGLAPIENTRY eglDestroyImageKHR (EGLDisplay dpy, EGLImageKHR image);
#endif /* EGL_EGLEXT_PROTOTYPES */
typedef EGLImageKHR (EGLAPIENTRYP PFNEGLCREATEIMAGEKHRPROC) (EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint *attrib_list);
typedef EGLBoolean (EGLAPIENTRYP PFNEGLDESTROYIMAGEKHRPROC) (EGLDisplay dpy, EGLImageKHR image);
#endif

#ifndef EGL_KHR_vg_parent_image
#define EGL_KHR_vg_parent_image 1
#define EGL_VG_PARENT_IMAGE_KHR         0x30BA  /* eglCreateImageKHR target */
#endif

#ifndef EGL_KHR_gl_texture_2D_image
#define EGL_KHR_gl_texture_2D_image 1
#define EGL_GL_TEXTURE_2D_KHR           0x30B1  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_LEVEL_KHR        0x30BC  /* eglCreateImageKHR attribute */
#endif

#ifndef EGL_KHR_gl_texture_cubemap_image
#define EGL_KHR_gl_texture_cubemap_image 1
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR  0x30B3  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR  0x30B4  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR  0x30B5  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR  0x30B6  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR  0x30B7  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR  0x30B8  /* eglCreateImageKHR target */
#endif

#ifndef EGL_KHR_gl_texture_3D_image
#define EGL_KHR_gl_texture_3D_image 1
#define EGL_GL_TEXTURE_3D_KHR           0x30B2  /* eglCreateImageKHR target */
#define EGL_GL_TEXTURE_ZOFFSET_KHR      0x30BD  /* eglCreateImageKHR attribute */
#endif

#ifndef EGL_KHR_gl_renderbuffer_image
#define EGL_KHR_gl_renderbuffer_image 1
#define EGL_GL_RENDERBUFFER_KHR         0x30B9  /* eglCreateImageKHR target */
#endif

#ifndef EGL_KHR_image_base
#define EGL_KHR_image_base 1
/* Most interfaces defined by EGL_KHR_image_pixmap above */
#define EGL_IMAGE_PRESERVED_KHR         0x30D2  /* eglCreateImageKHR attribute */
#endif

#ifndef EGL_KHR_image_pixmap
#define EGL_KHR_image_pixmap 1
/* Interfaces defined by EGL_KHR_image above */
#endif

#ifdef ANDROID
#define EGL_NATIVE_BUFFER_ANDROID       0x3140  /* eglCreateImageKHR target for android*/
#endif

// Added by AMD to make things build (probably should be removed someday)

#if defined(_WIN32) || defined(_WINCE)
typedef unsigned __int64 uint64_t;
#elif defined (__GNUC) || defined (__SYMBIAN32__)
typedef unsigned long long uint64_t;
#endif


#define EGL_INITIALIZED                                 0xFFFF
#define EGL_SWAP_INTERVAL                               0xFFFE
#define EGL_WINDOW_SURFACE                              0xFFFB
#define EGL_PBUFFER_SURFACE                             0xFFFA
#define EGL_PIXMAP_SURFACE                              0xFFF9

#ifndef EGL_Sync_KHR
#define EGL_Sync_KHR 1
/*
 * EGLSyncKHR is an opaque handle to an EGL sync object
 */
typedef void* EGLSyncKHR;
/*
 * EGLTimeKHR is a 64-bit unsigned integer representing intervals in
 * nanoseconds (unadjusted standard time).  Here, it is defined as
 * appropriate for an ISO C compiler.
 */
#ifndef _LINUX
typedef uint64_t EGLTimeKHR;
#else   // _LINUX
typedef unsigned long long EGLTimeKHR;
#endif  // _LINUX

#define EGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR            0xFFF8
#define EGL_SYNC_STATUS_KHR                             0xFFF7                                  
#define EGL_SIGNALED_KHR                                0xFFF6
#define EGL_UNSIGNALED_KHR                              0xFFF5
#define EGL_SYNC_FLUSH_COMMANDS_BIT_KHR                 0x0001
#define EGL_FOREVER_KHR                                 0xFFFFFFFFFFFFFFFFull
#define EGL_ALREADY_SIGNALED_KHR                        0xFFF4
#define EGL_TIMEOUT_EXPIRED_KHR                         0xFFF3
#define EGL_CONDITION_SATISFIED_KHR                     0xFFF2
#define EGL_SYNC_TYPE_KHR                               0xFFF1
#define EGL_SYNC_CONDITION_KHR                          0xFFF0
#define EGL_SYNC_FENCE_KHR                              0xFFEF
#define EGL_NO_SYNC_KHR                                 0xFFEE
#endif

#if defined COMMANDLISTSURFACE || defined VG_IMAGE_EXT

typedef struct
{
    void *m_CLHandle; 
    void *m_memdesc; 
    unsigned int m_format; 
    unsigned int m_stride; 
    unsigned int m_width; 
    unsigned int m_height; 
    float m_matrix[9];
    unsigned int m_globalAlpha;
    unsigned int m_flipImage;
    void *context;
    void *tempBufferHandle;
    unsigned int m_tempStride; 
    unsigned int m_tempWidth; 
    unsigned int m_tempHeight; 
    int         *m_scissorRect;
    unsigned int m_copyBuffers;
    unsigned int m_forceTempBuffer;
}renderCLSToBuffer_t;

typedef enum                                          //!< Surface types
{
    VGEXT_SURFACE             = 0x01, // EGL surface.
    VGEXT_PSURFACE            = 0x02, // EGL surface.
    VGEXT_CLS                 = 0x04, // CommandListSurface.
    VGEXT_CLIENTBUF           = 0x08, // Clint buffer from image.
} VGImageSurfaceType;

EGLAPI EGLBoolean EGLAPIENTRY eglRetSurfaceDescriptor(EGLDisplay display, EGLContext context, EGLSurface surface, void *descriptor, VGImageSurfaceType *surfaceType );
EGLAPI EGLenum EGLAPIENTRY eglReleaseSurfaceRef( EGLDisplay display, EGLSurface surface );

#endif /* COMMANDLISTSURFACE/VG_IMAGE_EXT */

#ifdef __cplusplus
}
#endif

#endif
