// #define protected public
// #define private public
#include <libcapture/tree.h>
#include <libcapture/treenode.h>
#include <libcapture/treefactory.h>

#include <tut.h>

namespace tut {

    using namespace std;
    using namespace capture;

    struct tree_shar {
    };
    
    typedef test_group<tree_shar> tg;
    typedef tg::object to;
    tg tree_tg ("tree");

    class STF: public TreeFactory
    {
        public:
            TreePkgNode *makePkgNode (TreeNode *parent, pkgCache::PkgIterator P)
            { return new TreePkgNode (parent, P); }
            TreeBranchNode *makeBranchNode (TreeNode *parent, string id, string name)
            { return new TreeBranchNode (parent, id, name); }
            TreeGroupNode *makeGroupNode (TreeNode *parent, pkgTagSection s)
            { return new TreeGroupNode (parent, s); }
            TreeBranchNode *makeRoot () { return new TreeBranchNode (0, "ROOT"); }
            TreeDepNode *makeDepNode (TreeNode *parent, pkgCache::DepIterator) { return 0; }
            TreeVerNode *makeVerNode (TreeNode *parent, pkgCache::VerIterator) { return 0; }
    };

    /* class TestProd: public NodeProducer {
        public:
            Tree *t;
            void getNodes (TreeFactory *f, NodeConsumer *c)
            {
                TreeNode *a, *b;
                a = t -> top ();
                // c -> consumeNode (a = f -> makeBNode (t -> top (), "blah1"));
                c -> consumeNode (f -> makePkgNode (a, pkgCache::PkgIterator ()));
                c -> consumeNode (f -> makePkgNode (a, pkgCache::PkgIterator ()));
                c -> consumeNode (f -> makePkgNode (a, pkgCache::PkgIterator ()));
                // c -> consumeNode (b = f -> makeBNode (t -> top (), "blah2"));
                // c -> consumeNode (f -> makePkg (b, pkgCache::PkgIterator ()));
                // c -> consumeNode (f -> makePkg (b, pkgCache::PkgIterator ()));
            }
    }; */
    template<> template<>
    void to::test<1> () 
    {
        TreeFactory *f = new STF;
        TestProd *p = new TestProd;
        Tree *t = new Tree;
        GrouperChain *c = new GrouperChain ("grouperchain");
        c -> addFactory ("EndGrouper", "end");
        t -> setGrouper (c);
        t -> setProducer (p);
        t -> setTreeFact (f);
        p -> t = t;
        t -> rebuild ();

        TreeNode *A, *B, *C;
        ensure (t -> top ());
        A = t -> top () -> firstChild ();
        ensure (A);
        B = A -> nextSibling ();
        ensure (B);
        for (C = B; C -> nextSibling (); C = C -> nextSibling ());
        ensure (C);
        ensure (A -> nextSibling () == B);
        ensure (B -> nextSibling () == C);
        t -> refresh ();
        ensure (t -> top ());
        A = t -> top () -> firstChild ();
        ensure (A);
        B = A -> nextSibling ();
        ensure (B);
        for (C = B; C -> nextSibling (); C = C -> nextSibling ());
        ensure (C);
        ensure (A -> nextSibling () == B);
        ensure (B -> nextSibling () == C);
    }
};
