#ifndef EPT_NOTIFIER_H
#define EPT_NOTIFIER_H

#include <sys/types.h>
#include <ksystemtray.h>
#include <kuniqueapplication.h>

class QWidget;
class KAction;
// class KGlobalAccel;

// the status indicator in system tray
class TrayWindow : public KSystemTray
{
    Q_OBJECT
public:
    TrayWindow(QWidget *parent=0, const char *name=0);
	void setAvailableUpdates( int n );
    int updates() { return m_updates; }
	void contextMenuAboutToShow ( KPopupMenu * );
signals:
    void clicked();
    void aboutSelected();
protected:
    void mouseReleaseEvent( QMouseEvent * );
    int m_updates;
	KAction *m_quit, *m_about;
};


// application watching the current status
// it will update the icon and run 
class NotifierApp : public KUniqueApplication
{
    Q_OBJECT
public:
    NotifierApp(bool allowStyles=true, bool GUIenabled=true);
    ~NotifierApp();
    bool fileUpdated( const char *, time_t & );
    int upgradable();

protected slots:
// void menuActivated(int id);
    void clicked();
    void checkUpdates();
	void askQuit();
	void about();

protected:
    TrayWindow *m_tray;
    QTimer *m_timer;
    time_t m_updateStamp, m_statusStamp;
	bool m_okAutostart;
};

#endif
