/* files-widget.c generated by valac 0.14.2, the Vala compiler
 * generated from files-widget.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2012 Stefano Candori <stefano.candori@gmail.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <zeitgeist.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define ALM_TYPE_FILE_TYPE_BLACKLIST (alm_file_type_blacklist_get_type ())
#define ALM_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist))
#define ALM_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))
#define ALM_IS_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_IS_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_FILE_TYPE_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))

typedef struct _AlmFileTypeBlacklist AlmFileTypeBlacklist;
typedef struct _AlmFileTypeBlacklistClass AlmFileTypeBlacklistClass;
typedef struct _AlmFileTypeBlacklistPrivate AlmFileTypeBlacklistPrivate;

#define ALM_TYPE_BLACKLIST (alm_blacklist_get_type ())
#define ALM_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_BLACKLIST, AlmBlacklist))
#define ALM_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_BLACKLIST, AlmBlacklistClass))
#define ALM_IS_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_BLACKLIST))
#define ALM_IS_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_BLACKLIST))
#define ALM_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_BLACKLIST, AlmBlacklistClass))

typedef struct _AlmBlacklist AlmBlacklist;
typedef struct _AlmBlacklistClass AlmBlacklistClass;
#define _alm_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_blacklist_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _AlmParamSpecFileTypeBlacklist AlmParamSpecFileTypeBlacklist;

#define ALM_TYPE_PATH_BLACKLIST (alm_path_blacklist_get_type ())
#define ALM_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist))
#define ALM_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))
#define ALM_IS_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_PATH_BLACKLIST))
#define ALM_IS_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_PATH_BLACKLIST))
#define ALM_PATH_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))

typedef struct _AlmPathBlacklist AlmPathBlacklist;
typedef struct _AlmPathBlacklistClass AlmPathBlacklistClass;
typedef struct _AlmPathBlacklistPrivate AlmPathBlacklistPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AlmParamSpecPathBlacklist AlmParamSpecPathBlacklist;

#define ALM_TYPE_FILES_WIDGET (alm_files_widget_get_type ())
#define ALM_FILES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILES_WIDGET, AlmFilesWidget))
#define ALM_FILES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILES_WIDGET, AlmFilesWidgetClass))
#define ALM_IS_FILES_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILES_WIDGET))
#define ALM_IS_FILES_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILES_WIDGET))
#define ALM_FILES_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILES_WIDGET, AlmFilesWidgetClass))

typedef struct _AlmFilesWidget AlmFilesWidget;
typedef struct _AlmFilesWidgetClass AlmFilesWidgetClass;
typedef struct _AlmFilesWidgetPrivate AlmFilesWidgetPrivate;

#define ALM_FILES_WIDGET_TYPE_TREE_VIEW_COLS (alm_files_widget_tree_view_cols_get_type ())
#define _alm_file_type_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_file_type_blacklist_unref (var), NULL)))
#define _alm_path_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_path_blacklist_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

#define ALM_TYPE_FILES_CELL_RENDERER (alm_files_cell_renderer_get_type ())
#define ALM_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer))
#define ALM_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))
#define ALM_IS_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_IS_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_FILES_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))

typedef struct _AlmFilesCellRenderer AlmFilesCellRenderer;
typedef struct _AlmFilesCellRendererClass AlmFilesCellRendererClass;
typedef struct _AlmFilesCellRendererPrivate AlmFilesCellRendererPrivate;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _AlmFileTypeBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmFileTypeBlacklistPrivate * priv;
};

struct _AlmFileTypeBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmFileTypeBlacklist *self);
};

struct _AlmFileTypeBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashMap* checkboxes;
};

struct _AlmParamSpecFileTypeBlacklist {
	GParamSpec parent_instance;
};

struct _AlmPathBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmPathBlacklistPrivate * priv;
};

struct _AlmPathBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmPathBlacklist *self);
};

struct _AlmPathBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_folder;
};

struct _AlmParamSpecPathBlacklist {
	GParamSpec parent_instance;
};

struct _AlmFilesWidget {
	GtkBox parent_instance;
	AlmFilesWidgetPrivate * priv;
};

struct _AlmFilesWidgetClass {
	GtkBoxClass parent_class;
};

struct _AlmFilesWidgetPrivate {
	AlmFileTypeBlacklist* files_type_blacklist;
	AlmPathBlacklist* path_blacklist;
	GtkTreeView* folder_list;
	GtkListStore* folder_list_store;
	GeeHashMap* mime_dict;
	GeeHashMap* checkboxes;
	GeeHashSet* button_list;
	GeeHashMap* defined_dirs;
	AlmBlacklist* blacklist;
	gboolean file_type_fire_signal;
	GtkIconTheme* icon_theme;
	GdkPixbuf* stock_folder_icon;
};

typedef enum  {
	ALM_FILES_WIDGET_TREE_VIEW_COLS_APP_NAME,
	ALM_FILES_WIDGET_TREE_VIEW_COLS_ICON,
	ALM_FILES_WIDGET_TREE_VIEW_COLS_DESKTOP_FILE,
	ALM_FILES_WIDGET_TREE_VIEW_COLS_N_COLS
} AlmFilesWidgetTreeViewCols;

struct _Block3Data {
	int _ref_count_;
	AlmFilesWidget * self;
	GtkCheckButton* check_button;
};

struct _AlmFilesCellRenderer {
	GtkCellRenderer parent_instance;
	AlmFilesCellRendererPrivate * priv;
};

struct _AlmFilesCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _AlmFilesCellRendererPrivate {
	GtkWidget* current_widget;
	GdkPixbuf* pixbuf_;
	gchar* text_;
	gchar* path_;
};


static gpointer alm_file_type_blacklist_parent_class = NULL;
extern gchar* alm_file_type_blacklist_interpretation_prefix;
gchar* alm_file_type_blacklist_interpretation_prefix = NULL;
static gpointer alm_path_blacklist_parent_class = NULL;
extern gchar* alm_path_blacklist_folder_prefix;
gchar* alm_path_blacklist_folder_prefix = NULL;
static gchar* alm_path_blacklist_suffix;
static gchar* alm_path_blacklist_suffix = NULL;
static gpointer alm_files_widget_parent_class = NULL;
static gpointer alm_files_cell_renderer_parent_class = NULL;

gpointer alm_file_type_blacklist_ref (gpointer instance);
void alm_file_type_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_file_type_blacklist (GValue* value, gpointer v_object);
void alm_value_take_file_type_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_file_type_blacklist (const GValue* value);
GType alm_file_type_blacklist_get_type (void) G_GNUC_CONST;
gpointer alm_blacklist_ref (gpointer instance);
void alm_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_blacklist (GValue* value, gpointer v_object);
void alm_value_take_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_blacklist (const GValue* value);
GType alm_blacklist_get_type (void) G_GNUC_CONST;
#define ALM_FILE_TYPE_BLACKLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistPrivate))
enum  {
	ALM_FILE_TYPE_BLACKLIST_DUMMY_PROPERTY
};
AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes);
AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes);
static gchar* alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self);
GHashTable* alm_blacklist_get_all_templates (AlmBlacklist* self);
void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_blacklist_add_template (AlmBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template);
void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self, const gchar* interpretation);
void alm_blacklist_remove_template (AlmBlacklist* self, const gchar* blacklist_id);
static void alm_file_type_blacklist_finalize (AlmFileTypeBlacklist* obj);
gpointer alm_path_blacklist_ref (gpointer instance);
void alm_path_blacklist_unref (gpointer instance);
GParamSpec* alm_param_spec_path_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void alm_value_set_path_blacklist (GValue* value, gpointer v_object);
void alm_value_take_path_blacklist (GValue* value, gpointer v_object);
gpointer alm_value_get_path_blacklist (const GValue* value);
GType alm_path_blacklist_get_type (void) G_GNUC_CONST;
#define ALM_PATH_BLACKLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistPrivate))
enum  {
	ALM_PATH_BLACKLIST_DUMMY_PROPERTY
};
AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter);
AlmPathBlacklist* alm_path_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter);
static void alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self);
gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self, const gchar* path);
static gchar* alm_path_blacklist_get_folder (AlmPathBlacklist* self, ZeitgeistEvent* ev);
void alm_path_blacklist_block (AlmPathBlacklist* self, const gchar* folder);
void alm_path_blacklist_unblock (AlmPathBlacklist* self, const gchar* folder);
GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self);
static void alm_path_blacklist_finalize (AlmPathBlacklist* obj);
GType alm_files_widget_get_type (void) G_GNUC_CONST;
#define ALM_FILES_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_FILES_WIDGET, AlmFilesWidgetPrivate))
enum  {
	ALM_FILES_WIDGET_DUMMY_PROPERTY
};
static GType alm_files_widget_tree_view_cols_get_type (void) G_GNUC_UNUSED;
AlmFilesWidget* alm_files_widget_new (AlmBlacklist* blacklist_interface);
AlmFilesWidget* alm_files_widget_construct (GType object_type, AlmBlacklist* blacklist_interface);
static void __lambda8_ (AlmFilesWidget* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template);
static void ___lambda8__alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void __lambda9_ (AlmFilesWidget* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template);
static void ___lambda9__alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self);
static void __lambda10_ (AlmFilesWidget* self, const gchar* folder);
static void alm_files_widget_add_folder_to_view (AlmFilesWidget* self, const gchar* folder);
static void ___lambda10__alm_path_blacklist_folder_added (AlmPathBlacklist* _sender, const gchar* path, gpointer self);
static void __lambda11_ (AlmFilesWidget* self, const gchar* folder);
static gboolean alm_files_widget_remove_folder_from_view (AlmFilesWidget* self, const gchar* folder);
static void ___lambda11__alm_path_blacklist_folder_removed (AlmPathBlacklist* _sender, const gchar* path, gpointer self);
static void alm_files_widget_setup_ui (AlmFilesWidget* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void ____lambda12_ (Block3Data* _data3_);
static void _____lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
AlmFilesCellRenderer* alm_files_cell_renderer_new (void);
AlmFilesCellRenderer* alm_files_cell_renderer_construct (GType object_type);
GType alm_files_cell_renderer_get_type (void) G_GNUC_CONST;
static void alm_files_widget_on_add_folder (AlmFilesWidget* self);
static void _alm_files_widget_on_add_folder_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void alm_files_widget_on_remove_folder (AlmFilesWidget* self);
static void _alm_files_widget_on_remove_folder_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void alm_files_widget_folders_populate (AlmFilesWidget* self);
const gchar* g_user_directory_to_string (GUserDirectory self);
static const char* _g_user_directory_to_string (GUserDirectory value);
GdkPixbuf* alm_applications_tree_view_get_pixbuf_from_gio_icon (GIcon* icon, gint size);
static void alm_files_widget_finalize (GObject* obj);
#define ALM_FILES_CELL_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererPrivate))
enum  {
	ALM_FILES_CELL_RENDERER_DUMMY_PROPERTY,
	ALM_FILES_CELL_RENDERER_PIXBUF,
	ALM_FILES_CELL_RENDERER_TEXT,
	ALM_FILES_CELL_RENDERER_PATH
};
#define ALM_FILES_CELL_RENDERER_PIXBUF_SIZE 24
#define ALM_FILES_CELL_RENDERER_xspacing 3
#define ALM_FILES_CELL_RENDERER_default_width 60
#define ALM_FILES_CELL_RENDERER_renderer_height 50
static PangoLayout* alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags, const gchar* text, gboolean bold, gint size);
static void alm_files_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height);
static void alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* layout, gint* x_offset, gint* y_offset);
static void alm_files_cell_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags);
const gchar* alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self);
const gchar* alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self);
GdkPixbuf* alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self);
static void alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width);
static void alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height);
static void alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size);
void alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self, GdkPixbuf* value);
void alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self, const gchar* value);
void alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self, const gchar* value);
static void alm_files_cell_renderer_finalize (GObject* obj);
static void _vala_alm_files_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_alm_files_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _alm_blacklist_ref0 (gpointer self) {
	return self ? alm_blacklist_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes) {
	AlmFileTypeBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	g_return_val_if_fail (all_checkboxes != NULL, NULL);
	self = (AlmFileTypeBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = blacklist_inter;
	_tmp1_ = _alm_blacklist_ref0 (_tmp0_);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp1_;
	_tmp2_ = all_checkboxes;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->checkboxes);
	self->priv->checkboxes = _tmp3_;
	return self;
}


AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter, GeeHashMap* all_checkboxes) {
	return alm_file_type_blacklist_construct (ALM_TYPE_FILE_TYPE_BLACKLIST, blacklist_inter, all_checkboxes);
}


static gchar* alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* name;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interpretation != NULL, NULL);
	_tmp0_ = interpretation;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "#", 0);
	names = _tmp2_;
	names_length1 = _vala_array_length (_tmp1_);
	_names_size_ = names_length1;
	_tmp3_ = names[names_length1 - 1];
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
	name = _tmp4_;
	_tmp5_ = alm_file_type_blacklist_interpretation_prefix;
	_tmp6_ = g_strdup_printf ("%s%s", _tmp5_, name);
	result = _tmp6_;
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self) {
	AlmBlacklist* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_blacklist_get_all_templates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_get_keys (_tmp2_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp4_;
			gchar* key = NULL;
			_tmp4_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_ = FALSE;
				_tmp5_ = key;
				_tmp6_ = alm_file_type_blacklist_interpretation_prefix;
				_tmp7_ = g_str_has_prefix (_tmp5_, _tmp6_);
				if (_tmp7_) {
					AlmBlacklist* _tmp8_;
					GHashTable* _tmp9_;
					GHashTable* _tmp10_;
					const gchar* _tmp11_;
					gconstpointer _tmp12_ = NULL;
					ZeitgeistSubject* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* inter;
					GeeHashMap* _tmp16_;
					const gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp8_ = self->priv->blacklist_interface;
					_tmp9_ = alm_blacklist_get_all_templates (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = key;
					_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
					_tmp13_ = zeitgeist_event_get_subject ((ZeitgeistEvent*) _tmp12_, 0);
					_tmp14_ = zeitgeist_subject_get_interpretation (_tmp13_);
					_tmp15_ = g_strdup (_tmp14_);
					inter = _tmp15_;
					_tmp16_ = self->priv->checkboxes;
					_tmp17_ = inter;
					_tmp18_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, _tmp17_);
					if (_tmp18_) {
						GeeHashMap* _tmp19_;
						const gchar* _tmp20_;
						gpointer _tmp21_ = NULL;
						GtkCheckButton* _tmp22_;
						_tmp19_ = self->priv->checkboxes;
						_tmp20_ = inter;
						_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
						_tmp22_ = (GtkCheckButton*) _tmp21_;
						gtk_toggle_button_set_active ((GtkToggleButton*) _tmp22_, TRUE);
						_g_object_unref0 (_tmp22_);
					}
					_g_free0 (inter);
				}
				_g_free0 (key);
			}
		}
		_g_list_free0 (key_collection);
	}
}


void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistSubject* _tmp3_;
	ZeitgeistSubject* sub;
	const gchar* _tmp4_;
	AlmBlacklist* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = zeitgeist_event_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	ev = _tmp1_;
	_tmp2_ = zeitgeist_subject_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	sub = _tmp3_;
	_tmp4_ = interpretation;
	zeitgeist_subject_set_interpretation (sub, _tmp4_);
	zeitgeist_event_add_subject (ev, sub);
	_tmp5_ = self->priv->blacklist_interface;
	_tmp6_ = interpretation;
	_tmp7_ = alm_file_type_blacklist_get_name (self, _tmp6_);
	_tmp8_ = _tmp7_;
	alm_blacklist_add_template (_tmp5_, _tmp8_, ev);
	_g_free0 (_tmp8_);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}


void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self, const gchar* interpretation) {
	AlmBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = interpretation;
	_tmp2_ = alm_file_type_blacklist_get_name (self, _tmp1_);
	_tmp3_ = _tmp2_;
	alm_blacklist_remove_template (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


static void alm_value_file_type_blacklist_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void alm_value_file_type_blacklist_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		alm_file_type_blacklist_unref (value->data[0].v_pointer);
	}
}


static void alm_value_file_type_blacklist_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_file_type_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer alm_value_file_type_blacklist_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* alm_value_file_type_blacklist_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AlmFileTypeBlacklist* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_file_type_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* alm_value_file_type_blacklist_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AlmFileTypeBlacklist** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_file_type_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AlmParamSpecFileTypeBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer alm_value_get_file_type_blacklist (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}


void alm_value_set_file_type_blacklist (GValue* value, gpointer v_object) {
	AlmFileTypeBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_file_type_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}


void alm_value_take_file_type_blacklist (GValue* value, gpointer v_object) {
	AlmFileTypeBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}


static void alm_file_type_blacklist_class_init (AlmFileTypeBlacklistClass * klass) {
	gchar* _tmp0_;
	alm_file_type_blacklist_parent_class = g_type_class_peek_parent (klass);
	ALM_FILE_TYPE_BLACKLIST_CLASS (klass)->finalize = alm_file_type_blacklist_finalize;
	g_type_class_add_private (klass, sizeof (AlmFileTypeBlacklistPrivate));
	_tmp0_ = g_strdup ("interpretation-");
	alm_file_type_blacklist_interpretation_prefix = _tmp0_;
}


static void alm_file_type_blacklist_instance_init (AlmFileTypeBlacklist * self) {
	self->priv = ALM_FILE_TYPE_BLACKLIST_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void alm_file_type_blacklist_finalize (AlmFileTypeBlacklist* obj) {
	AlmFileTypeBlacklist * self;
	self = ALM_FILE_TYPE_BLACKLIST (obj);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->checkboxes);
}


GType alm_file_type_blacklist_get_type (void) {
	static volatile gsize alm_file_type_blacklist_type_id__volatile = 0;
	if (g_once_init_enter (&alm_file_type_blacklist_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { alm_value_file_type_blacklist_init, alm_value_file_type_blacklist_free_value, alm_value_file_type_blacklist_copy_value, alm_value_file_type_blacklist_peek_pointer, "p", alm_value_file_type_blacklist_collect_value, "p", alm_value_file_type_blacklist_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlmFileTypeBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_file_type_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFileTypeBlacklist), 0, (GInstanceInitFunc) alm_file_type_blacklist_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alm_file_type_blacklist_type_id;
		alm_file_type_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmFileTypeBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alm_file_type_blacklist_type_id__volatile, alm_file_type_blacklist_type_id);
	}
	return alm_file_type_blacklist_type_id__volatile;
}


gpointer alm_file_type_blacklist_ref (gpointer instance) {
	AlmFileTypeBlacklist* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void alm_file_type_blacklist_unref (gpointer instance) {
	AlmFileTypeBlacklist* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_FILE_TYPE_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	alm_path_blacklist_on_blacklist_added (self, blacklist_id, blacklist_template);
}


static void _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	alm_path_blacklist_on_blacklist_removed (self, blacklist_id, blacklist_template);
}


AlmPathBlacklist* alm_path_blacklist_construct (GType object_type, AlmBlacklist* blacklist_inter) {
	AlmPathBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	AlmBlacklist* _tmp2_;
	AlmBlacklist* _tmp3_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	self = (AlmPathBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = blacklist_inter;
	_tmp1_ = _alm_blacklist_ref0 (_tmp0_);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp1_;
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-added", (GCallback) _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added, self);
	_tmp3_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp3_, "template-removed", (GCallback) _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed, self);
	alm_path_blacklist_get_blocked_folder (self);
	return self;
}


AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter) {
	return alm_path_blacklist_construct (ALM_TYPE_PATH_BLACKLIST, blacklist_inter);
}


gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self, const gchar* path) {
	gboolean result = FALSE;
	GeeHashSet* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->all_blocked_folder;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self) {
	GeeHashSet* _tmp0_;
	AlmBlacklist* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_folder);
	self->priv->all_blocked_folder = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	_tmp2_ = alm_blacklist_get_all_templates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp4_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp6_ = key;
				_tmp7_ = alm_path_blacklist_folder_prefix;
				_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
				if (_tmp8_) {
					AlmBlacklist* _tmp9_;
					GHashTable* _tmp10_;
					GHashTable* _tmp11_;
					const gchar* _tmp12_;
					gconstpointer _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* folder;
					const gchar* _tmp15_;
					_tmp9_ = self->priv->blacklist_interface;
					_tmp10_ = alm_blacklist_get_all_templates (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = key;
					_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
					_tmp14_ = alm_path_blacklist_get_folder (self, (ZeitgeistEvent*) _tmp13_);
					folder = _tmp14_;
					_tmp15_ = folder;
					if (_tmp15_ != NULL) {
						GeeHashSet* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = self->priv->all_blocked_folder;
						_tmp17_ = folder;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					}
					_g_free0 (folder);
				}
				_g_free0 (key);
			}
		}
		_g_list_free0 (key_collection);
	}
}


static void alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* uri;
		const gchar* _tmp5_;
		_tmp3_ = ev;
		_tmp4_ = alm_path_blacklist_get_folder (self, _tmp3_);
		uri = _tmp4_;
		_tmp5_ = uri;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = uri;
			g_signal_emit_by_name (self, "folder-added", _tmp6_);
			_tmp7_ = self->priv->all_blocked_folder;
			_tmp8_ = uri;
			_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			if (!_tmp9_) {
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = self->priv->all_blocked_folder;
				_tmp11_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
		}
		_g_free0 (uri);
	}
}


static void alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self, const gchar* blacklist_id, ZeitgeistEvent* ev) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* uri;
		const gchar* _tmp5_;
		_tmp3_ = ev;
		_tmp4_ = alm_path_blacklist_get_folder (self, _tmp3_);
		uri = _tmp4_;
		_tmp5_ = uri;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			GeeHashSet* _tmp7_;
			const gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = uri;
			g_signal_emit_by_name (self, "folder-removed", _tmp6_);
			_tmp7_ = self->priv->all_blocked_folder;
			_tmp8_ = uri;
			_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			if (_tmp9_) {
				GeeHashSet* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = self->priv->all_blocked_folder;
				_tmp11_ = uri;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
		}
		_g_free0 (uri);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch2_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* alm_path_blacklist_get_folder (AlmPathBlacklist* self, ZeitgeistEvent* ev) {
	gchar* result = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* _tmp1_ = NULL;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistSubject* sub;
	ZeitgeistSubject* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* uri;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* blocked_uri;
	gchar* _tmp11_ = NULL;
	GFile* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* final_path;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ev != NULL, NULL);
	_tmp0_ = ev;
	_tmp1_ = zeitgeist_event_get_subject (_tmp0_, 0);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	sub = _tmp2_;
	_tmp3_ = sub;
	_tmp4_ = zeitgeist_subject_get_uri (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	uri = _tmp5_;
	_tmp6_ = uri;
	_tmp7_ = alm_path_blacklist_suffix;
	_tmp8_ = string_replace (_tmp6_, _tmp7_, "");
	_g_free0 (uri);
	uri = _tmp8_;
	_tmp9_ = uri;
	_tmp10_ = g_file_new_for_uri (_tmp9_);
	blocked_uri = _tmp10_;
	_tmp12_ = blocked_uri;
	_tmp13_ = g_file_query_exists (_tmp12_, NULL);
	if (_tmp13_) {
		GFile* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp14_ = blocked_uri;
		_tmp15_ = g_file_get_path (_tmp14_);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp15_;
	} else {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	}
	_tmp16_ = _tmp11_;
	_tmp17_ = g_strdup (_tmp16_);
	final_path = _tmp17_;
	result = final_path;
	_g_free0 (_tmp11_);
	_g_object_unref0 (blocked_uri);
	_g_free0 (uri);
	_g_object_unref0 (sub);
	return result;
}


void alm_path_blacklist_block (AlmPathBlacklist* self, const gchar* folder) {
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* _tmp1_;
	ZeitgeistEvent* ev;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistSubject* _tmp3_;
	ZeitgeistSubject* sub;
	const gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* block_path;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* uri;
	ZeitgeistSubject* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	ZeitgeistSubject* _tmp15_;
	AlmBlacklist* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	ZeitgeistEvent* _tmp21_;
	GeeHashSet* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = zeitgeist_event_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	ev = _tmp1_;
	_tmp2_ = zeitgeist_subject_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	sub = _tmp3_;
	_tmp4_ = folder;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	block_path = _tmp5_;
	_tmp6_ = block_path;
	_tmp7_ = g_file_get_uri (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = alm_path_blacklist_suffix;
	_tmp10_ = g_strdup_printf ("%s%s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp8_);
	uri = _tmp11_;
	_tmp12_ = sub;
	_tmp13_ = uri;
	zeitgeist_subject_set_uri (_tmp12_, _tmp13_);
	_tmp14_ = ev;
	_tmp15_ = sub;
	zeitgeist_event_add_subject (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->blacklist_interface;
	_tmp17_ = alm_path_blacklist_folder_prefix;
	_tmp18_ = folder;
	_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = ev;
	alm_blacklist_add_template (_tmp16_, _tmp20_, _tmp21_);
	_g_free0 (_tmp20_);
	_tmp22_ = self->priv->all_blocked_folder;
	_tmp23_ = folder;
	_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, _tmp23_);
	if (!_tmp24_) {
		GeeHashSet* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = self->priv->all_blocked_folder;
		_tmp26_ = folder;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
	}
	_g_free0 (uri);
	_g_object_unref0 (block_path);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}


void alm_path_blacklist_unblock (AlmPathBlacklist* self, const gchar* folder) {
	AlmBlacklist* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	GeeHashSet* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = folder;
	_tmp3_ = g_strdup_printf ("%s%s", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	alm_blacklist_remove_template (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->all_blocked_folder;
	_tmp6_ = folder;
	_tmp7_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp5_, _tmp6_);
	if (_tmp7_) {
		GeeHashSet* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->all_blocked_folder;
		_tmp9_ = folder;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	}
}


GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self) {
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_folder;
	result = _tmp0_;
	return result;
}


static void alm_value_path_blacklist_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void alm_value_path_blacklist_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		alm_path_blacklist_unref (value->data[0].v_pointer);
	}
}


static void alm_value_path_blacklist_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_path_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer alm_value_path_blacklist_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* alm_value_path_blacklist_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AlmPathBlacklist* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_path_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* alm_value_path_blacklist_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AlmPathBlacklist** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_path_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* alm_param_spec_path_blacklist (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AlmParamSpecPathBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_PATH_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer alm_value_get_path_blacklist (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}


void alm_value_set_path_blacklist (GValue* value, gpointer v_object) {
	AlmPathBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_path_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}


void alm_value_take_path_blacklist (GValue* value, gpointer v_object) {
	AlmPathBlacklist* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}


static void alm_path_blacklist_class_init (AlmPathBlacklistClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	alm_path_blacklist_parent_class = g_type_class_peek_parent (klass);
	ALM_PATH_BLACKLIST_CLASS (klass)->finalize = alm_path_blacklist_finalize;
	g_type_class_add_private (klass, sizeof (AlmPathBlacklistPrivate));
	g_signal_new ("folder_added", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("folder_removed", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	_tmp0_ = g_strdup ("dir-");
	alm_path_blacklist_folder_prefix = _tmp0_;
	_tmp1_ = g_strdup ("/*");
	alm_path_blacklist_suffix = _tmp1_;
}


static void alm_path_blacklist_instance_init (AlmPathBlacklist * self) {
	self->priv = ALM_PATH_BLACKLIST_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void alm_path_blacklist_finalize (AlmPathBlacklist* obj) {
	AlmPathBlacklist * self;
	self = ALM_PATH_BLACKLIST (obj);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_folder);
}


GType alm_path_blacklist_get_type (void) {
	static volatile gsize alm_path_blacklist_type_id__volatile = 0;
	if (g_once_init_enter (&alm_path_blacklist_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { alm_value_path_blacklist_init, alm_value_path_blacklist_free_value, alm_value_path_blacklist_copy_value, alm_value_path_blacklist_peek_pointer, "p", alm_value_path_blacklist_collect_value, "p", alm_value_path_blacklist_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AlmPathBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_path_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmPathBlacklist), 0, (GInstanceInitFunc) alm_path_blacklist_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType alm_path_blacklist_type_id;
		alm_path_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmPathBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&alm_path_blacklist_type_id__volatile, alm_path_blacklist_type_id);
	}
	return alm_path_blacklist_type_id__volatile;
}


gpointer alm_path_blacklist_ref (gpointer instance) {
	AlmPathBlacklist* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void alm_path_blacklist_unref (gpointer instance) {
	AlmPathBlacklist* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_PATH_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static GType alm_files_widget_tree_view_cols_get_type (void) {
	static volatile gsize alm_files_widget_tree_view_cols_type_id__volatile = 0;
	if (g_once_init_enter (&alm_files_widget_tree_view_cols_type_id__volatile)) {
		static const GEnumValue values[] = {{ALM_FILES_WIDGET_TREE_VIEW_COLS_APP_NAME, "ALM_FILES_WIDGET_TREE_VIEW_COLS_APP_NAME", "app-name"}, {ALM_FILES_WIDGET_TREE_VIEW_COLS_ICON, "ALM_FILES_WIDGET_TREE_VIEW_COLS_ICON", "icon"}, {ALM_FILES_WIDGET_TREE_VIEW_COLS_DESKTOP_FILE, "ALM_FILES_WIDGET_TREE_VIEW_COLS_DESKTOP_FILE", "desktop-file"}, {ALM_FILES_WIDGET_TREE_VIEW_COLS_N_COLS, "ALM_FILES_WIDGET_TREE_VIEW_COLS_N_COLS", "n-cols"}, {0, NULL, NULL}};
		GType alm_files_widget_tree_view_cols_type_id;
		alm_files_widget_tree_view_cols_type_id = g_enum_register_static ("AlmFilesWidgetTreeViewCols", values);
		g_once_init_leave (&alm_files_widget_tree_view_cols_type_id__volatile, alm_files_widget_tree_view_cols_type_id);
	}
	return alm_files_widget_tree_view_cols_type_id__volatile;
}


static void __lambda8_ (AlmFilesWidget* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_file_type_blacklist_interpretation_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		ZeitgeistSubject* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* inter;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		self->priv->file_type_fire_signal = FALSE;
		_tmp3_ = blacklist_template;
		_tmp4_ = zeitgeist_event_get_subject (_tmp3_, 0);
		_tmp5_ = zeitgeist_subject_get_interpretation (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		inter = _tmp6_;
		_tmp7_ = self->priv->checkboxes;
		_tmp8_ = inter;
		_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
		if (_tmp9_) {
			GeeHashMap* _tmp10_;
			const gchar* _tmp11_;
			gpointer _tmp12_ = NULL;
			GtkCheckButton* _tmp13_;
			_tmp10_ = self->priv->checkboxes;
			_tmp11_ = inter;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
			_tmp13_ = (GtkCheckButton*) _tmp12_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, TRUE);
			_g_object_unref0 (_tmp13_);
		}
		self->priv->file_type_fire_signal = TRUE;
		_g_free0 (inter);
	}
}


static void ___lambda8__alm_blacklist_template_added (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	__lambda8_ (self, blacklist_id, blacklist_template);
}


static void __lambda9_ (AlmFilesWidget* self, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	_tmp0_ = blacklist_id;
	_tmp1_ = alm_file_type_blacklist_interpretation_prefix;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		ZeitgeistEvent* _tmp3_;
		ZeitgeistSubject* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* inter;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		self->priv->file_type_fire_signal = FALSE;
		_tmp3_ = blacklist_template;
		_tmp4_ = zeitgeist_event_get_subject (_tmp3_, 0);
		_tmp5_ = zeitgeist_subject_get_interpretation (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		inter = _tmp6_;
		_tmp7_ = self->priv->checkboxes;
		_tmp8_ = inter;
		_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_);
		if (_tmp9_) {
			GeeHashMap* _tmp10_;
			const gchar* _tmp11_;
			gpointer _tmp12_ = NULL;
			GtkCheckButton* _tmp13_;
			_tmp10_ = self->priv->checkboxes;
			_tmp11_ = inter;
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
			_tmp13_ = (GtkCheckButton*) _tmp12_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, FALSE);
			_g_object_unref0 (_tmp13_);
		}
		self->priv->file_type_fire_signal = TRUE;
		_g_free0 (inter);
	}
}


static void ___lambda9__alm_blacklist_template_removed (AlmBlacklist* _sender, const gchar* blacklist_id, ZeitgeistEvent* blacklist_template, gpointer self) {
	__lambda9_ (self, blacklist_id, blacklist_template);
}


static void __lambda10_ (AlmFilesWidget* self, const gchar* folder) {
	AlmPathBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->path_blacklist;
	_tmp1_ = folder;
	_tmp2_ = alm_path_blacklist_is_duplicate (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = folder;
		alm_files_widget_add_folder_to_view (self, _tmp3_);
	}
}


static void ___lambda10__alm_path_blacklist_folder_added (AlmPathBlacklist* _sender, const gchar* path, gpointer self) {
	__lambda10_ (self, path);
}


static void __lambda11_ (AlmFilesWidget* self, const gchar* folder) {
	const gchar* _tmp0_;
	g_return_if_fail (folder != NULL);
	_tmp0_ = folder;
	alm_files_widget_remove_folder_from_view (self, _tmp0_);
}


static void ___lambda11__alm_path_blacklist_folder_removed (AlmPathBlacklist* _sender, const gchar* path, gpointer self) {
	__lambda11_ (self, path);
}


AlmFilesWidget* alm_files_widget_construct (GType object_type, AlmBlacklist* blacklist_interface) {
	AlmFilesWidget * self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashSet* _tmp3_;
	GtkIconTheme* _tmp4_;
	AlmBlacklist* _tmp5_;
	GeeHashMap* _tmp6_;
	AlmFileTypeBlacklist* _tmp7_;
	AlmBlacklist* _tmp8_;
	AlmPathBlacklist* _tmp9_;
	AlmBlacklist* _tmp10_;
	AlmBlacklist* _tmp11_;
	AlmPathBlacklist* _tmp12_;
	AlmPathBlacklist* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GeeHashMap* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GeeHashMap* _tmp21_;
	const gchar* _tmp22_ = NULL;
	GeeHashMap* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GeeHashMap* _tmp25_;
	const gchar* _tmp26_ = NULL;
	GeeHashMap* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GeeHashMap* _tmp29_;
	const gchar* _tmp30_ = NULL;
	GeeHashMap* _tmp31_;
	const gchar* _tmp32_ = NULL;
	GeeHashMap* _tmp33_;
	const gchar* _tmp34_ = NULL;
	GHashFunc _tmp35_;
	GEqualFunc _tmp36_;
	GeeHashMap* _tmp37_;
	GeeHashMap* _tmp38_;
	const gchar* _tmp39_ = NULL;
	GeeHashMap* _tmp40_;
	const gchar* _tmp41_ = NULL;
	GeeHashMap* _tmp42_;
	const gchar* _tmp43_ = NULL;
	GeeHashMap* _tmp44_;
	const gchar* _tmp45_ = NULL;
	GeeHashMap* _tmp46_;
	const gchar* _tmp47_ = NULL;
	GeeHashMap* _tmp48_;
	const gchar* _tmp49_ = NULL;
	GeeHashMap* _tmp50_;
	const gchar* _tmp51_ = NULL;
	GeeHashMap* _tmp52_;
	const gchar* _tmp53_ = NULL;
	GdkPixbuf* _tmp54_ = NULL;
	GdkPixbuf* _tmp55_;
	g_return_val_if_fail (blacklist_interface != NULL, NULL);
	self = (AlmFilesWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = blacklist_interface;
	_tmp1_ = _alm_blacklist_ref0 (_tmp0_);
	_alm_blacklist_unref0 (self->priv->blacklist);
	self->priv->blacklist = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GTK_TYPE_CHECK_BUTTON, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->checkboxes);
	self->priv->checkboxes = _tmp2_;
	_tmp3_ = gee_hash_set_new (GTK_TYPE_CHECK_BUTTON, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->button_list);
	self->priv->button_list = _tmp3_;
	_tmp4_ = gtk_icon_theme_new ();
	_g_object_unref0 (self->priv->icon_theme);
	self->priv->icon_theme = _tmp4_;
	_tmp5_ = blacklist_interface;
	_tmp6_ = self->priv->checkboxes;
	_tmp7_ = alm_file_type_blacklist_new (_tmp5_, _tmp6_);
	_alm_file_type_blacklist_unref0 (self->priv->files_type_blacklist);
	self->priv->files_type_blacklist = _tmp7_;
	_tmp8_ = blacklist_interface;
	_tmp9_ = alm_path_blacklist_new (_tmp8_);
	_alm_path_blacklist_unref0 (self->priv->path_blacklist);
	self->priv->path_blacklist = _tmp9_;
	_tmp10_ = blacklist_interface;
	g_signal_connect_object (_tmp10_, "template-added", (GCallback) ___lambda8__alm_blacklist_template_added, self, 0);
	_tmp11_ = blacklist_interface;
	g_signal_connect_object (_tmp11_, "template-removed", (GCallback) ___lambda9__alm_blacklist_template_removed, self, 0);
	_tmp12_ = self->priv->path_blacklist;
	g_signal_connect_object (_tmp12_, "folder-added", (GCallback) ___lambda10__alm_path_blacklist_folder_added, self, 0);
	_tmp13_ = self->priv->path_blacklist;
	g_signal_connect_object (_tmp13_, "folder-removed", (GCallback) ___lambda11__alm_path_blacklist_folder_removed, self, 0);
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp14_, _tmp15_, NULL);
	_g_object_unref0 (self->priv->mime_dict);
	self->priv->mime_dict = _tmp16_;
	_tmp17_ = self->priv->mime_dict;
	_tmp18_ = _ ("Audio");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp18_, ZEITGEIST_NFO_AUDIO);
	_tmp19_ = self->priv->mime_dict;
	_tmp20_ = _ ("Video");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp20_, ZEITGEIST_NFO_VIDEO);
	_tmp21_ = self->priv->mime_dict;
	_tmp22_ = _ ("Image");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp22_, ZEITGEIST_NFO_IMAGE);
	_tmp23_ = self->priv->mime_dict;
	_tmp24_ = _ ("Text");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, ZEITGEIST_NFO_DOCUMENT);
	_tmp25_ = self->priv->mime_dict;
	_tmp26_ = _ ("Presentation");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, ZEITGEIST_NFO_PRESENTATION);
	_tmp27_ = self->priv->mime_dict;
	_tmp28_ = _ ("Spreadsheet");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, ZEITGEIST_NFO_SPREADSHEET);
	_tmp29_ = self->priv->mime_dict;
	_tmp30_ = _ ("Instant Messaging");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp30_, ZEITGEIST_NMO_IMMESSAGE);
	_tmp31_ = self->priv->mime_dict;
	_tmp32_ = _ ("E-mail");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp31_, _tmp32_, ZEITGEIST_NMO_EMAIL);
	_tmp33_ = self->priv->mime_dict;
	_tmp34_ = _ ("Website");
	gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, _tmp34_, ZEITGEIST_NFO_WEBSITE);
	_tmp35_ = g_str_hash;
	_tmp36_ = g_str_equal;
	_tmp37_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, _tmp35_, _tmp36_, NULL);
	_g_object_unref0 (self->priv->defined_dirs);
	self->priv->defined_dirs = _tmp37_;
	_tmp38_ = self->priv->defined_dirs;
	_tmp39_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp38_, _tmp39_, GINT_TO_POINTER (G_USER_DIRECTORY_DESKTOP));
	_tmp40_ = self->priv->defined_dirs;
	_tmp41_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp40_, _tmp41_, GINT_TO_POINTER (G_USER_DIRECTORY_DOCUMENTS));
	_tmp42_ = self->priv->defined_dirs;
	_tmp43_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp43_, GINT_TO_POINTER (G_USER_DIRECTORY_DOWNLOAD));
	_tmp44_ = self->priv->defined_dirs;
	_tmp45_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp44_, _tmp45_, GINT_TO_POINTER (G_USER_DIRECTORY_MUSIC));
	_tmp46_ = self->priv->defined_dirs;
	_tmp47_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp46_, _tmp47_, GINT_TO_POINTER (G_USER_DIRECTORY_PICTURES));
	_tmp48_ = self->priv->defined_dirs;
	_tmp49_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp48_, _tmp49_, GINT_TO_POINTER (G_USER_DIRECTORY_PUBLIC_SHARE));
	_tmp50_ = self->priv->defined_dirs;
	_tmp51_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp50_, _tmp51_, GINT_TO_POINTER (G_USER_DIRECTORY_TEMPLATES));
	_tmp52_ = self->priv->defined_dirs;
	_tmp53_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, _tmp53_, GINT_TO_POINTER (G_USER_DIRECTORY_VIDEOS));
	_tmp54_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) self, GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_LARGE_TOOLBAR);
	_tmp55_ = _g_object_ref0 (_tmp54_);
	_g_object_unref0 (self->priv->stock_folder_icon);
	self->priv->stock_folder_icon = _tmp55_;
	alm_files_widget_setup_ui (self);
	return self;
}


AlmFilesWidget* alm_files_widget_new (AlmBlacklist* blacklist_interface) {
	return alm_files_widget_construct (ALM_TYPE_FILES_WIDGET, blacklist_interface);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->check_button);
		g_slice_free (Block3Data, _data3_);
	}
}


static void ____lambda12_ (Block3Data* _data3_) {
	AlmFilesWidget * self;
	gboolean _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->file_type_fire_signal;
	if (_tmp0_) {
		GtkCheckButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		self->priv->file_type_fire_signal = FALSE;
		_tmp1_ = _data3_->check_button;
		_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			AlmFileTypeBlacklist* _tmp4_;
			GeeHashMap* _tmp5_;
			GtkCheckButton* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp4_ = self->priv->files_type_blacklist;
			_tmp5_ = self->priv->mime_dict;
			_tmp6_ = _data3_->check_button;
			_tmp7_ = gtk_button_get_label ((GtkButton*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp8_);
			_tmp10_ = (gchar*) _tmp9_;
			alm_file_type_blacklist_block (_tmp4_, _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			AlmFileTypeBlacklist* _tmp11_;
			GeeHashMap* _tmp12_;
			GtkCheckButton* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp11_ = self->priv->files_type_blacklist;
			_tmp12_ = self->priv->mime_dict;
			_tmp13_ = _data3_->check_button;
			_tmp14_ = gtk_button_get_label ((GtkButton*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp15_);
			_tmp17_ = (gchar*) _tmp16_;
			alm_file_type_blacklist_unblock (_tmp11_, _tmp17_);
			_g_free0 (_tmp17_);
		}
		self->priv->file_type_fire_signal = TRUE;
	}
}


static void _____lambda12__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	____lambda12_ (self);
}


static void _alm_files_widget_on_add_folder_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	alm_files_widget_on_add_folder (self);
}


static void _alm_files_widget_on_remove_folder_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	alm_files_widget_on_remove_folder (self);
}


static void alm_files_widget_setup_ui (AlmFilesWidget* self) {
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* vbox_file_types;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* file_type_label;
	GtkLabel* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	GtkLabel* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkTable* _tmp12_;
	GtkTable* _tmp13_;
	GtkTable* checkbox_table;
	GeeHashMap* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	gint _tmp18_ = 0;
	gpointer* _tmp19_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	GtkBox* _tmp51_;
	GtkTable* _tmp52_;
	AlmFileTypeBlacklist* _tmp53_;
	GtkHSeparator* _tmp61_;
	GtkHSeparator* _tmp62_;
	GtkHSeparator* hoz_line;
	GtkBox* _tmp63_;
	GtkBox* _tmp64_;
	GtkBox* vbox_folders;
	GtkLabel* _tmp65_;
	GtkLabel* _tmp66_;
	GtkLabel* folders_label;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_;
	GtkBox* _tmp70_;
	GtkBox* _tmp71_;
	GtkBox* file_chooser_vbox;
	GtkListStore* _tmp72_;
	GtkListStore* _tmp73_;
	GtkTreeView* _tmp74_;
	GtkTreeView* _tmp75_;
	GtkTreeView* _tmp76_;
	GtkTreeView* _tmp77_;
	GtkTreeViewColumn* _tmp78_;
	GtkTreeViewColumn* _tmp79_;
	GtkTreeViewColumn* column_pix_name;
	const gchar* _tmp80_ = NULL;
	GtkTreeView* _tmp81_;
	AlmFilesCellRenderer* _tmp82_;
	AlmFilesCellRenderer* _tmp83_;
	AlmFilesCellRenderer* pix_rend;
	GtkScrolledWindow* _tmp84_;
	GtkScrolledWindow* _tmp85_;
	GtkScrolledWindow* scroll;
	GtkTreeView* _tmp86_;
	GtkToolbar* _tmp87_;
	GtkToolbar* _tmp88_;
	GtkToolbar* folder_toolbar;
	GtkStyleContext* _tmp89_ = NULL;
	GtkStyleContext* _tmp90_ = NULL;
	GtkStyleContext* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	GtkToolButton* _tmp93_;
	GtkToolButton* _tmp94_;
	GtkToolButton* folder_add;
	const gchar* _tmp95_ = NULL;
	GtkToolButton* _tmp96_;
	GtkToolButton* _tmp97_;
	GtkToolButton* folder_remove;
	g_return_if_fail (self != NULL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	vbox_file_types = _tmp1_;
	_tmp2_ = vbox_file_types;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	file_type_label = _tmp4_;
	_tmp5_ = file_type_label;
	_tmp6_ = _ ("Don't record activity for following type of files:");
	_tmp7_ = g_strdup_printf ("<b>%s</b>", _tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_markup (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = file_type_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp9_, 0.0f, 0.5f);
	_tmp10_ = vbox_file_types;
	_tmp11_ = file_type_label;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, FALSE, TRUE, (guint) 0);
	_tmp12_ = (GtkTable*) gtk_table_new ((guint) 3, (guint) 3, TRUE);
	_tmp13_ = g_object_ref_sink (_tmp12_);
	checkbox_table = _tmp13_;
	_tmp14_ = self->priv->mime_dict;
	_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp19_ = gee_collection_to_array ((GeeCollection*) _tmp17_, &_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp18_;
	_g_object_unref0 (_tmp17_);
	keys = _tmp20_;
	keys_length1 = _tmp20__length1;
	_keys_size_ = keys_length1;
	{
		gint i;
		gint row;
		gint col;
		i = 0;
		row = 0;
		col = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_;
				gint _tmp25_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gint _tmp28_;
				const gchar* _tmp29_;
				GtkCheckButton* _tmp30_;
				GtkCheckButton* _tmp31_;
				GtkCheckButton* check_button;
				GeeHashSet* _tmp32_;
				GtkCheckButton* _tmp33_;
				GeeHashMap* _tmp34_;
				GeeHashMap* _tmp35_;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				const gchar* _tmp38_;
				gpointer _tmp39_ = NULL;
				gchar* _tmp40_;
				GtkCheckButton* _tmp41_;
				gint _tmp42_;
				GtkTable* _tmp45_;
				GtkCheckButton* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				_tmp22_ = _tmp21_;
				if (!_tmp22_) {
					gint _tmp23_;
					gint _tmp24_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
					_tmp24_ = col;
					col = _tmp24_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = keys;
				_tmp26__length1 = keys_length1;
				if (!(_tmp25_ < _tmp26__length1)) {
					break;
				}
				_tmp27_ = keys;
				_tmp27__length1 = keys_length1;
				_tmp28_ = i;
				_tmp29_ = _tmp27_[_tmp28_];
				_tmp30_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp29_);
				_tmp31_ = g_object_ref_sink (_tmp30_);
				check_button = _tmp31_;
				_tmp32_ = self->priv->button_list;
				_tmp33_ = check_button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
				_tmp34_ = self->priv->checkboxes;
				_tmp35_ = self->priv->mime_dict;
				_tmp36_ = keys;
				_tmp36__length1 = keys_length1;
				_tmp37_ = i;
				_tmp38_ = _tmp36_[_tmp37_];
				_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp35_, _tmp38_);
				_tmp40_ = (gchar*) _tmp39_;
				_tmp41_ = check_button;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, _tmp40_, _tmp41_);
				_g_free0 (_tmp40_);
				_tmp42_ = col;
				if (_tmp42_ > 2) {
					gint _tmp43_;
					gint _tmp44_;
					_tmp43_ = row;
					row = _tmp43_ + 1;
					_tmp44_ = col;
					col = _tmp44_ % 3;
				}
				_tmp45_ = checkbox_table;
				_tmp46_ = check_button;
				_tmp47_ = col;
				_tmp48_ = col;
				_tmp49_ = row;
				_tmp50_ = row;
				gtk_table_attach_defaults (_tmp45_, (GtkWidget*) _tmp46_, (guint) _tmp47_, (guint) (_tmp48_ + 1), (guint) _tmp49_, (guint) (_tmp50_ + 1));
				_g_object_unref0 (check_button);
			}
		}
	}
	_tmp51_ = vbox_file_types;
	_tmp52_ = checkbox_table;
	gtk_box_pack_start (_tmp51_, (GtkWidget*) _tmp52_, FALSE, TRUE, (guint) 0);
	_tmp53_ = self->priv->files_type_blacklist;
	alm_file_type_blacklist_populate_file_types (_tmp53_);
	{
		GeeHashSet* _tmp54_;
		GeeIterator* _tmp55_ = NULL;
		GeeIterator* _check_button_it;
		_tmp54_ = self->priv->button_list;
		_tmp55_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp54_);
		_check_button_it = _tmp55_;
		while (TRUE) {
			Block3Data* _data3_;
			GeeIterator* _tmp56_;
			gboolean _tmp57_ = FALSE;
			GeeIterator* _tmp58_;
			gpointer _tmp59_ = NULL;
			GtkCheckButton* _tmp60_;
			_data3_ = g_slice_new0 (Block3Data);
			_data3_->_ref_count_ = 1;
			_data3_->self = g_object_ref (self);
			_tmp56_ = _check_button_it;
			_tmp57_ = gee_iterator_next (_tmp56_);
			if (!_tmp57_) {
				block3_data_unref (_data3_);
				_data3_ = NULL;
				break;
			}
			_tmp58_ = _check_button_it;
			_tmp59_ = gee_iterator_get (_tmp58_);
			_data3_->check_button = (GtkCheckButton*) _tmp59_;
			_tmp60_ = _data3_->check_button;
			g_signal_connect_data ((GtkToggleButton*) _tmp60_, "toggled", (GCallback) _____lambda12__gtk_toggle_button_toggled, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
			block3_data_unref (_data3_);
			_data3_ = NULL;
		}
		_g_object_unref0 (_check_button_it);
	}
	_tmp61_ = (GtkHSeparator*) gtk_hseparator_new ();
	_tmp62_ = g_object_ref_sink (_tmp61_);
	hoz_line = _tmp62_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) hoz_line, FALSE, FALSE, (guint) 12);
	_tmp63_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	vbox_folders = _tmp64_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox_folders, TRUE, TRUE, (guint) 0);
	_tmp65_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp66_ = g_object_ref_sink (_tmp65_);
	folders_label = _tmp66_;
	_tmp67_ = _ ("Don't record activity in the following folders:");
	_tmp68_ = g_strdup_printf ("<b>%s</b>", _tmp67_);
	_tmp69_ = _tmp68_;
	gtk_label_set_markup (folders_label, _tmp69_);
	_g_free0 (_tmp69_);
	gtk_misc_set_alignment ((GtkMisc*) folders_label, 0.0f, 0.5f);
	gtk_box_pack_start (vbox_folders, (GtkWidget*) folders_label, FALSE, TRUE, (guint) 0);
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp71_ = g_object_ref_sink (_tmp70_);
	file_chooser_vbox = _tmp71_;
	gtk_box_pack_start (vbox_folders, (GtkWidget*) file_chooser_vbox, TRUE, TRUE, (guint) 0);
	_tmp72_ = gtk_list_store_new (3, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING);
	_g_object_unref0 (self->priv->folder_list_store);
	self->priv->folder_list_store = _tmp72_;
	_tmp73_ = self->priv->folder_list_store;
	_tmp74_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp73_);
	_tmp75_ = g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->folder_list);
	self->priv->folder_list = _tmp75_;
	_tmp76_ = self->priv->folder_list;
	gtk_tree_view_set_headers_visible (_tmp76_, FALSE);
	_tmp77_ = self->priv->folder_list;
	gtk_tree_view_set_rules_hint (_tmp77_, TRUE);
	_tmp78_ = gtk_tree_view_column_new ();
	_tmp79_ = g_object_ref_sink (_tmp78_);
	column_pix_name = _tmp79_;
	_tmp80_ = _ ("Name");
	gtk_tree_view_column_set_title (column_pix_name, _tmp80_);
	_tmp81_ = self->priv->folder_list;
	gtk_tree_view_append_column (_tmp81_, column_pix_name);
	_tmp82_ = alm_files_cell_renderer_new ();
	_tmp83_ = g_object_ref_sink (_tmp82_);
	pix_rend = _tmp83_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, "pixbuf", 1);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, "text", 2);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, "path", 0);
	_tmp84_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp85_ = g_object_ref_sink (_tmp84_);
	scroll = _tmp85_;
	_tmp86_ = self->priv->folder_list;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp86_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
	gtk_container_set_border_width ((GtkContainer*) scroll, (guint) 1);
	gtk_box_pack_start (file_chooser_vbox, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	_tmp87_ = (GtkToolbar*) gtk_toolbar_new ();
	_tmp88_ = g_object_ref_sink (_tmp87_);
	folder_toolbar = _tmp88_;
	g_object_set (folder_toolbar, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	gtk_toolbar_set_icon_size (folder_toolbar, 1);
	g_object_set (folder_toolbar, "icon-size-set", TRUE, NULL);
	gtk_widget_set_visible ((GtkWidget*) folder_toolbar, TRUE);
	_tmp89_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_set_junction_sides (_tmp89_, GTK_JUNCTION_BOTTOM);
	_tmp90_ = gtk_widget_get_style_context ((GtkWidget*) folder_toolbar);
	gtk_style_context_add_class (_tmp90_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp91_ = gtk_widget_get_style_context ((GtkWidget*) folder_toolbar);
	gtk_style_context_set_junction_sides (_tmp91_, GTK_JUNCTION_TOP);
	_tmp92_ = _ ("Add Folder");
	_tmp93_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp92_);
	_tmp94_ = g_object_ref_sink (_tmp93_);
	folder_add = _tmp94_;
	gtk_tool_button_set_icon_name (folder_add, "list-add-symbolic");
	g_signal_connect_object (folder_add, "clicked", (GCallback) _alm_files_widget_on_add_folder_gtk_tool_button_clicked, self, 0);
	_tmp95_ = _ ("Remove Folder");
	_tmp96_ = (GtkToolButton*) gtk_tool_button_new (NULL, _tmp95_);
	_tmp97_ = g_object_ref_sink (_tmp96_);
	folder_remove = _tmp97_;
	gtk_tool_button_set_icon_name (folder_remove, "list-remove-symbolic");
	g_signal_connect_object (folder_remove, "clicked", (GCallback) _alm_files_widget_on_remove_folder_gtk_tool_button_clicked, self, 0);
	gtk_toolbar_insert (folder_toolbar, (GtkToolItem*) folder_add, 0);
	gtk_toolbar_insert (folder_toolbar, (GtkToolItem*) folder_remove, 1);
	gtk_box_pack_start (file_chooser_vbox, (GtkWidget*) folder_toolbar, FALSE, FALSE, (guint) 0);
	alm_files_widget_folders_populate (self);
	_g_object_unref0 (folder_remove);
	_g_object_unref0 (folder_add);
	_g_object_unref0 (folder_toolbar);
	_g_object_unref0 (scroll);
	_g_object_unref0 (pix_rend);
	_g_object_unref0 (column_pix_name);
	_g_object_unref0 (file_chooser_vbox);
	_g_object_unref0 (folders_label);
	_g_object_unref0 (vbox_folders);
	_g_object_unref0 (hoz_line);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (checkbox_table);
	_g_object_unref0 (file_type_label);
	_g_object_unref0 (vbox_file_types);
}


static void alm_files_widget_folders_populate (AlmFilesWidget* self) {
	g_return_if_fail (self != NULL);
	{
		AlmPathBlacklist* _tmp0_;
		GeeHashSet* _tmp1_;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _folder_it;
		_tmp0_ = self->priv->path_blacklist;
		_tmp1_ = alm_path_blacklist_get_all_folders (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_folder_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			GeeIterator* _tmp6_;
			gpointer _tmp7_ = NULL;
			gchar* folder;
			const gchar* _tmp8_;
			_tmp4_ = _folder_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _folder_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			folder = (gchar*) _tmp7_;
			_tmp8_ = folder;
			alm_files_widget_add_folder_to_view (self, _tmp8_);
			_g_free0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
}


static void alm_files_widget_on_add_folder (AlmFilesWidget* self) {
	const gchar* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* chooser;
	GtkFileChooserDialog* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	gint _tmp5_ = 0;
	gint res;
	GtkFileChooserDialog* _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Select a directory to blacklist");
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	chooser = _tmp2_;
	_tmp3_ = chooser;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp3_, GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	_tmp4_ = chooser;
	_tmp5_ = gtk_dialog_run ((GtkDialog*) _tmp4_);
	res = _tmp5_;
	_tmp6_ = chooser;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
	_tmp7_ = res;
	if (_tmp7_ == ((gint) GTK_RESPONSE_OK)) {
		GtkFileChooserDialog* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* folder;
		AlmPathBlacklist* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp8_ = chooser;
		_tmp9_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp8_);
		folder = _tmp9_;
		_tmp10_ = self->priv->path_blacklist;
		_tmp11_ = folder;
		_tmp12_ = alm_path_blacklist_is_duplicate (_tmp10_, _tmp11_);
		if (!_tmp12_) {
			const gchar* _tmp13_;
			AlmPathBlacklist* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = folder;
			alm_files_widget_add_folder_to_view (self, _tmp13_);
			_tmp14_ = self->priv->path_blacklist;
			_tmp15_ = folder;
			alm_path_blacklist_block (_tmp14_, _tmp15_);
		}
		_g_free0 (folder);
	}
	_g_object_unref0 (chooser);
}


static void alm_files_widget_on_remove_folder (AlmFilesWidget* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* sel;
	GtkTreeSelection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->folder_list;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	sel = _tmp2_;
	_tmp3_ = sel;
	if (_tmp3_ != NULL) {
		GtkTreeModel* model = NULL;
		GtkTreeIter iter = {0};
		GtkTreeSelection* _tmp4_;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_ = FALSE;
		GtkTreeModel* _tmp8_;
		_tmp4_ = sel;
		_tmp7_ = gtk_tree_selection_get_selected (_tmp4_, &_tmp5_, &_tmp6_);
		_g_object_unref0 (model);
		_tmp8_ = _g_object_ref0 (_tmp5_);
		model = _tmp8_;
		iter = _tmp6_;
		if (_tmp7_) {
			gchar* folder = NULL;
			GtkTreeModel* _tmp9_;
			GtkTreeIter _tmp10_;
			const gchar* _tmp11_;
			_tmp9_ = model;
			_tmp10_ = iter;
			gtk_tree_model_get (_tmp9_, &_tmp10_, 0, &folder, -1);
			_tmp11_ = folder;
			if (_tmp11_ != NULL) {
				GtkListStore* _tmp12_;
				GtkTreeIter _tmp13_;
				AlmPathBlacklist* _tmp14_;
				const gchar* _tmp15_;
				_tmp12_ = self->priv->folder_list_store;
				_tmp13_ = iter;
				gtk_list_store_remove (_tmp12_, &_tmp13_);
				_tmp14_ = self->priv->path_blacklist;
				_tmp15_ = folder;
				alm_path_blacklist_unblock (_tmp14_, _tmp15_);
			}
			_g_free0 (folder);
		}
		_g_object_unref0 (model);
	}
	_g_object_unref0 (sel);
}


static const char* _g_user_directory_to_string (GUserDirectory value) {
	switch (value) {
		case G_USER_DIRECTORY_DESKTOP:
		return "G_USER_DIRECTORY_DESKTOP";
		case G_USER_DIRECTORY_DOCUMENTS:
		return "G_USER_DIRECTORY_DOCUMENTS";
		case G_USER_DIRECTORY_DOWNLOAD:
		return "G_USER_DIRECTORY_DOWNLOAD";
		case G_USER_DIRECTORY_MUSIC:
		return "G_USER_DIRECTORY_MUSIC";
		case G_USER_DIRECTORY_PICTURES:
		return "G_USER_DIRECTORY_PICTURES";
		case G_USER_DIRECTORY_PUBLIC_SHARE:
		return "G_USER_DIRECTORY_PUBLIC_SHARE";
		case G_USER_DIRECTORY_TEMPLATES:
		return "G_USER_DIRECTORY_TEMPLATES";
		case G_USER_DIRECTORY_VIDEOS:
		return "G_USER_DIRECTORY_VIDEOS";
		case G_USER_N_DIRECTORIES:
		return "G_USER_N_DIRECTORIES";
	}
	return NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void alm_files_widget_add_folder_to_view (AlmFilesWidget* self, const gchar* folder) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* icon;
	GThemedIcon* nautilus_icon;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gchar* name;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp43_;
	GtkTreeIter _tmp44_ = {0};
	GtkListStore* _tmp45_;
	GtkTreeIter _tmp46_;
	const gchar* _tmp47_;
	GdkPixbuf* _tmp48_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->stock_folder_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon = _tmp1_;
	nautilus_icon = NULL;
	_tmp2_ = self->priv->defined_dirs;
	_tmp3_ = folder;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_ = NULL;
		GUserDirectory dir;
		GUserDirectory _tmp8_;
		const gchar* _tmp9_ = NULL;
		GThemedIcon* _tmp32_;
		_tmp5_ = self->priv->defined_dirs;
		_tmp6_ = folder;
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
		dir = GPOINTER_TO_INT (_tmp7_);
		_tmp8_ = dir;
		_tmp9_ = _g_user_directory_to_string (_tmp8_);
		if (g_strcmp0 (_tmp9_, "G_USER_DIRECTORY_DOCUMENTS") == 0) {
			GThemedIcon* _tmp10_;
			_tmp10_ = (GThemedIcon*) g_themed_icon_new ("folder-documents");
			_g_object_unref0 (nautilus_icon);
			nautilus_icon = _tmp10_;
		} else {
			GUserDirectory _tmp11_;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = dir;
			_tmp12_ = _g_user_directory_to_string (_tmp11_);
			if (g_strcmp0 (_tmp12_, "G_USER_DIRECTORY_DOWNLOAD") == 0) {
				GThemedIcon* _tmp13_;
				_tmp13_ = (GThemedIcon*) g_themed_icon_new ("folder-download");
				_g_object_unref0 (nautilus_icon);
				nautilus_icon = _tmp13_;
			} else {
				GUserDirectory _tmp14_;
				const gchar* _tmp15_ = NULL;
				_tmp14_ = dir;
				_tmp15_ = _g_user_directory_to_string (_tmp14_);
				if (g_strcmp0 (_tmp15_, "G_USER_DIRECTORY_MUSIC") == 0) {
					GThemedIcon* _tmp16_;
					_tmp16_ = (GThemedIcon*) g_themed_icon_new ("folder-music");
					_g_object_unref0 (nautilus_icon);
					nautilus_icon = _tmp16_;
				} else {
					GUserDirectory _tmp17_;
					const gchar* _tmp18_ = NULL;
					_tmp17_ = dir;
					_tmp18_ = _g_user_directory_to_string (_tmp17_);
					if (g_strcmp0 (_tmp18_, "G_USER_DIRECTORY_DESKTOP") == 0) {
						GThemedIcon* _tmp19_;
						_tmp19_ = (GThemedIcon*) g_themed_icon_new ("user-desktop");
						_g_object_unref0 (nautilus_icon);
						nautilus_icon = _tmp19_;
					} else {
						GUserDirectory _tmp20_;
						const gchar* _tmp21_ = NULL;
						_tmp20_ = dir;
						_tmp21_ = _g_user_directory_to_string (_tmp20_);
						if (g_strcmp0 (_tmp21_, "G_USER_DIRECTORY_PICTURES") == 0) {
							GThemedIcon* _tmp22_;
							_tmp22_ = (GThemedIcon*) g_themed_icon_new ("folder-pictures");
							_g_object_unref0 (nautilus_icon);
							nautilus_icon = _tmp22_;
						} else {
							GUserDirectory _tmp23_;
							const gchar* _tmp24_ = NULL;
							_tmp23_ = dir;
							_tmp24_ = _g_user_directory_to_string (_tmp23_);
							if (g_strcmp0 (_tmp24_, "G_USER_DIRECTORY_VIDEOS") == 0) {
								GThemedIcon* _tmp25_;
								_tmp25_ = (GThemedIcon*) g_themed_icon_new ("folder-videos");
								_g_object_unref0 (nautilus_icon);
								nautilus_icon = _tmp25_;
							} else {
								GUserDirectory _tmp26_;
								const gchar* _tmp27_ = NULL;
								_tmp26_ = dir;
								_tmp27_ = _g_user_directory_to_string (_tmp26_);
								if (g_strcmp0 (_tmp27_, "G_USER_DIRECTORY_TEMPLATES") == 0) {
									GThemedIcon* _tmp28_;
									_tmp28_ = (GThemedIcon*) g_themed_icon_new ("folder-templates");
									_g_object_unref0 (nautilus_icon);
									nautilus_icon = _tmp28_;
								} else {
									GUserDirectory _tmp29_;
									const gchar* _tmp30_ = NULL;
									_tmp29_ = dir;
									_tmp30_ = _g_user_directory_to_string (_tmp29_);
									if (g_strcmp0 (_tmp30_, "G_USER_DIRECTORY_PUBLIC_SHARE") == 0) {
										GThemedIcon* _tmp31_;
										_tmp31_ = (GThemedIcon*) g_themed_icon_new ("folder-publicshare");
										_g_object_unref0 (nautilus_icon);
										nautilus_icon = _tmp31_;
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp32_ = nautilus_icon;
		if (_tmp32_ != NULL) {
			GThemedIcon* _tmp33_;
			GdkPixbuf* _tmp34_ = NULL;
			GdkPixbuf* pixbuf;
			GdkPixbuf* _tmp35_;
			_tmp33_ = nautilus_icon;
			_tmp34_ = alm_applications_tree_view_get_pixbuf_from_gio_icon ((GIcon*) _tmp33_, 24);
			pixbuf = _tmp34_;
			_tmp35_ = pixbuf;
			if (_tmp35_ != NULL) {
				GdkPixbuf* _tmp36_;
				GdkPixbuf* _tmp37_;
				_tmp36_ = pixbuf;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_g_object_unref0 (icon);
				icon = _tmp37_;
			}
			_g_object_unref0 (pixbuf);
		}
	}
	_tmp38_ = folder;
	_tmp39_ = string_strip (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_path_get_basename (_tmp40_);
	_tmp42_ = _tmp41_;
	_g_free0 (_tmp40_);
	name = _tmp42_;
	_tmp43_ = self->priv->folder_list_store;
	gtk_list_store_append (_tmp43_, &_tmp44_);
	iter = _tmp44_;
	_tmp45_ = self->priv->folder_list_store;
	_tmp46_ = iter;
	_tmp47_ = folder;
	_tmp48_ = icon;
	gtk_list_store_set (_tmp45_, &_tmp46_, 0, _tmp47_, 1, _tmp48_, 2, name, -1, -1);
	_g_free0 (name);
	_g_object_unref0 (nautilus_icon);
	_g_object_unref0 (icon);
}


static gboolean alm_files_widget_remove_folder_from_view (AlmFilesWidget* self, const gchar* folder) {
	gboolean result = FALSE;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = self->priv->folder_list;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	while (TRUE) {
		GValue can_app_value = {0};
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		GValue _tmp7_ = {0};
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* cand_folder;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GtkTreeModel* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gboolean more_entires;
		gboolean _tmp16_;
		_tmp5_ = model;
		_tmp6_ = iter;
		gtk_tree_model_get_value (_tmp5_, &_tmp6_, 0, &_tmp7_);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
		can_app_value = _tmp7_;
		_tmp8_ = g_value_get_string (&can_app_value);
		_tmp9_ = g_strdup (_tmp8_);
		cand_folder = _tmp9_;
		_tmp10_ = folder;
		_tmp11_ = cand_folder;
		if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
			GtkListStore* _tmp12_;
			GtkTreeIter _tmp13_;
			_tmp12_ = self->priv->folder_list_store;
			_tmp13_ = iter;
			gtk_list_store_remove (_tmp12_, &_tmp13_);
			result = TRUE;
			_g_free0 (cand_folder);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			_g_object_unref0 (model);
			return result;
		}
		_tmp14_ = model;
		_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
		more_entires = _tmp15_;
		_tmp16_ = more_entires;
		if (!_tmp16_) {
			result = FALSE;
			_g_free0 (cand_folder);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			_g_object_unref0 (model);
			return result;
		}
		_g_free0 (cand_folder);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
	}
	_g_object_unref0 (model);
}


static void alm_files_widget_class_init (AlmFilesWidgetClass * klass) {
	alm_files_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AlmFilesWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = alm_files_widget_finalize;
}


static void alm_files_widget_instance_init (AlmFilesWidget * self) {
	self->priv = ALM_FILES_WIDGET_GET_PRIVATE (self);
	self->priv->file_type_fire_signal = TRUE;
}


static void alm_files_widget_finalize (GObject* obj) {
	AlmFilesWidget * self;
	self = ALM_FILES_WIDGET (obj);
	_alm_file_type_blacklist_unref0 (self->priv->files_type_blacklist);
	_alm_path_blacklist_unref0 (self->priv->path_blacklist);
	_g_object_unref0 (self->priv->folder_list);
	_g_object_unref0 (self->priv->folder_list_store);
	_g_object_unref0 (self->priv->mime_dict);
	_g_object_unref0 (self->priv->checkboxes);
	_g_object_unref0 (self->priv->button_list);
	_g_object_unref0 (self->priv->defined_dirs);
	_alm_blacklist_unref0 (self->priv->blacklist);
	_g_object_unref0 (self->priv->icon_theme);
	_g_object_unref0 (self->priv->stock_folder_icon);
	G_OBJECT_CLASS (alm_files_widget_parent_class)->finalize (obj);
}


GType alm_files_widget_get_type (void) {
	static volatile gsize alm_files_widget_type_id__volatile = 0;
	if (g_once_init_enter (&alm_files_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AlmFilesWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_files_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFilesWidget), 0, (GInstanceInitFunc) alm_files_widget_instance_init, NULL };
		GType alm_files_widget_type_id;
		alm_files_widget_type_id = g_type_register_static (GTK_TYPE_BOX, "AlmFilesWidget", &g_define_type_info, 0);
		g_once_init_leave (&alm_files_widget_type_id__volatile, alm_files_widget_type_id);
	}
	return alm_files_widget_type_id__volatile;
}


AlmFilesCellRenderer* alm_files_cell_renderer_construct (GType object_type) {
	AlmFilesCellRenderer * self = NULL;
	self = (AlmFilesCellRenderer*) g_object_new (object_type, NULL);
	return self;
}


AlmFilesCellRenderer* alm_files_cell_renderer_new (void) {
	return alm_files_cell_renderer_construct (ALM_TYPE_FILES_CELL_RENDERER);
}


static PangoLayout* alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, GtkCellRendererState flags, const gchar* text, gboolean bold, gint size) {
	PangoLayout* result = NULL;
	PangoLayout* layout = NULL;
	gint xpad = 0;
	PangoAttrList* _tmp0_;
	PangoAttrList* attr_list;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	PangoLayout* _tmp3_ = NULL;
	gint _tmp4_;
	PangoAttrSize* _tmp5_;
	PangoAttrSize* attr;
	PangoAttrSize* _tmp6_;
	PangoAttrSize* _tmp7_;
	PangoAttrSize* _tmp8_;
	PangoAttrSize* _tmp9_;
	guint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	PangoAttrList* _tmp14_;
	PangoAttrSize* _tmp15_;
	gboolean _tmp16_;
	PangoLayout* _tmp23_;
	PangoAttrList* _tmp24_;
	gint _tmp25_ = 0;
	PangoLayout* _tmp26_;
	PangoRectangle rect = {0};
	gint width = 0;
	gint text_width = 0;
	PangoLayout* _tmp27_;
	PangoRectangle _tmp28_ = {0};
	PangoRectangle _tmp29_;
	gint _tmp30_;
	GdkRectangle* _tmp31_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_ = 0;
	PangoLayout* _tmp38_;
	gint _tmp39_;
	PangoAlignment align = 0;
	GtkWidget* _tmp40_;
	GtkTextDirection _tmp41_ = 0;
	PangoLayout* _tmp42_;
	PangoAlignment _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attr_list = _tmp0_;
	_tmp1_ = widget;
	_tmp2_ = text;
	_tmp3_ = gtk_widget_create_pango_layout (_tmp1_, _tmp2_);
	_g_object_unref0 (layout);
	layout = _tmp3_;
	_tmp4_ = size;
	_tmp5_ = (PangoAttrSize*) pango_attr_size_new (_tmp4_ * PANGO_SCALE);
	attr = _tmp5_;
	_tmp6_ = attr;
	_tmp6_->absolute = (guint) 1;
	_tmp7_ = attr;
	((PangoAttribute*) _tmp7_)->start_index = (guint) 0;
	_tmp8_ = attr;
	_tmp9_ = attr;
	_tmp10_ = ((PangoAttribute*) _tmp9_)->start_index;
	_tmp11_ = text;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	((PangoAttribute*) _tmp8_)->end_index = _tmp10_ + _tmp13_;
	_tmp14_ = attr_list;
	_tmp15_ = attr;
	attr = NULL;
	pango_attr_list_insert (_tmp14_, (PangoAttribute*) _tmp15_);
	_tmp16_ = bold;
	if (_tmp16_) {
		PangoFontDescription* _tmp17_;
		PangoFontDescription* desc;
		const PangoFontDescription* _tmp18_;
		const PangoFontDescription* _tmp19_;
		PangoAttrFontDesc* _tmp20_;
		PangoAttrFontDesc* attr_f;
		PangoAttrList* _tmp21_;
		PangoAttrFontDesc* _tmp22_;
		_tmp17_ = pango_font_description_new ();
		desc = _tmp17_;
		_tmp18_ = desc;
		pango_font_description_set_weight (_tmp18_, PANGO_WEIGHT_BOLD);
		_tmp19_ = desc;
		_tmp20_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp19_);
		attr_f = _tmp20_;
		_tmp21_ = attr_list;
		_tmp22_ = attr_f;
		attr_f = NULL;
		pango_attr_list_insert (_tmp21_, (PangoAttribute*) _tmp22_);
		_pango_attribute_destroy0 (attr_f);
		_pango_font_description_free0 (desc);
	}
	_tmp23_ = layout;
	_tmp24_ = attr_list;
	pango_layout_set_attributes (_tmp23_, _tmp24_);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp25_, NULL);
	xpad = _tmp25_;
	_tmp26_ = layout;
	pango_layout_set_ellipsize (_tmp26_, PANGO_ELLIPSIZE_END);
	_tmp27_ = layout;
	pango_layout_get_extents (_tmp27_, NULL, &_tmp28_);
	rect = _tmp28_;
	_tmp29_ = rect;
	_tmp30_ = _tmp29_.width;
	text_width = _tmp30_;
	_tmp31_ = cell_area;
	if (_tmp31_ != NULL) {
		GdkRectangle* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		_tmp32_ = cell_area;
		_tmp33_ = (*_tmp32_).width;
		_tmp34_ = xpad;
		width = (_tmp33_ - _tmp34_) * PANGO_SCALE;
	} else {
		width = ALM_FILES_CELL_RENDERER_default_width * PANGO_SCALE;
	}
	_tmp35_ = width;
	_tmp36_ = text_width;
	_tmp37_ = MIN (_tmp35_, _tmp36_);
	width = _tmp37_;
	_tmp38_ = layout;
	_tmp39_ = width;
	pango_layout_set_width (_tmp38_, _tmp39_);
	_tmp40_ = widget;
	_tmp41_ = gtk_widget_get_direction (_tmp40_);
	if (_tmp41_ == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	_tmp42_ = layout;
	_tmp43_ = align;
	pango_layout_set_alignment (_tmp42_, _tmp43_);
	result = layout;
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attr_list);
	return result;
}


static void alm_files_cell_renderer_real_get_size (GtkCellRenderer* base, GtkWidget* widget, GdkRectangle* cell_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	AlmFilesCellRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_height = 0;
	_vala_width = _vala_height;
	_vala_y_offset = _vala_width;
	_vala_x_offset = _vala_y_offset;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


static void alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self, GtkWidget* widget, GdkRectangle* cell_area, PangoLayout* layout, gint* x_offset, gint* y_offset) {
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* _tmp2_;
	PangoRectangle _tmp3_ = {0};
	GdkRectangle* _tmp4_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	_tmp2_ = layout;
	pango_layout_get_pixel_extents (_tmp2_, NULL, &_tmp3_);
	rect = _tmp3_;
	_tmp4_ = cell_area;
	if (_tmp4_ != NULL) {
		PangoRectangle _tmp5_;
		gint _tmp6_;
		GdkRectangle* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		GtkWidget* _tmp11_;
		GtkTextDirection _tmp12_ = 0;
		gint _tmp19_;
		gint _tmp20_ = 0;
		_tmp5_ = rect;
		_tmp6_ = _tmp5_.width;
		_tmp7_ = cell_area;
		_tmp8_ = (*_tmp7_).width;
		_tmp9_ = xpad;
		_tmp10_ = MIN (_tmp6_, (_tmp8_ - (2 * _tmp9_)) + ALM_FILES_CELL_RENDERER_xspacing);
		rect.width = _tmp10_;
		_tmp11_ = widget;
		_tmp12_ = gtk_widget_get_direction (_tmp11_);
		if (_tmp12_ == GTK_TEXT_DIR_RTL) {
			GdkRectangle* _tmp13_;
			gint _tmp14_;
			PangoRectangle _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp13_ = cell_area;
			_tmp14_ = (*_tmp13_).width;
			_tmp15_ = rect;
			_tmp16_ = _tmp15_.width;
			_tmp17_ = xpad;
			_vala_x_offset = _tmp14_ - (_tmp16_ + _tmp17_);
		} else {
			gint _tmp18_;
			_tmp18_ = xpad;
			_vala_x_offset = _tmp18_;
		}
		_tmp19_ = _vala_x_offset;
		_tmp20_ = MAX (_tmp19_, 0);
		_vala_x_offset = _tmp20_;
	} else {
		_vala_x_offset = 0;
	}
	_tmp21_ = ypad;
	_vala_y_offset = _tmp21_;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}


static void alm_files_cell_renderer_real_render (GtkCellRenderer* base, cairo_t* cr, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags) {
	AlmFilesCellRenderer * self;
	GtkStyleContext* context = NULL;
	PangoLayout* text_layout = NULL;
	PangoLayout* path_layout = NULL;
	gint text_x_offset;
	gint path_x_offset;
	gint text_y_offset;
	gint path_y_offset;
	gint xpad = 0;
	PangoRectangle text_rect = {0};
	PangoRectangle path_rect = {0};
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_;
	const PangoFontDescription* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint font_size;
	gint _tmp7_ = 0;
	GtkWidget* _tmp8_;
	GdkRectangle _tmp9_;
	GtkCellRendererState _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	PangoLayout* _tmp13_ = NULL;
	GtkWidget* _tmp14_;
	GdkRectangle _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	PangoRectangle _tmp18_ = {0};
	gint _tmp19_;
	PangoRectangle _tmp20_;
	gint _tmp21_;
	GtkWidget* _tmp22_;
	GdkRectangle _tmp23_;
	GtkCellRendererState _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	PangoLayout* _tmp27_ = NULL;
	GtkWidget* _tmp28_;
	GdkRectangle _tmp29_;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	PangoRectangle _tmp32_ = {0};
	gint _tmp33_;
	PangoRectangle _tmp34_;
	gint _tmp35_;
	cairo_t* _tmp36_;
	cairo_t* _tmp37_;
	GdkRectangle _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	GdkPixbuf* _tmp41_;
	GdkPixbuf* _tmp42_;
	GdkRectangle _tmp43_;
	gint _tmp44_;
	GdkRectangle _tmp45_;
	gint _tmp46_;
	cairo_t* _tmp47_;
	cairo_t* _tmp48_;
	GdkRectangle _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GdkPixbuf* _tmp52_;
	GdkPixbuf* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GdkRectangle _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	cairo_t* _tmp59_;
	GdkRectangle _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	GdkRectangle _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gint _tmp66_ = 0;
	cairo_t* _tmp67_;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	text_x_offset = 0;
	path_x_offset = 0;
	text_y_offset = 0;
	path_y_offset = 0;
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (context);
	context = _tmp4_;
	_tmp5_ = gtk_style_context_get_font (context, GTK_STATE_FLAG_NORMAL);
	_tmp6_ = pango_font_description_get_size (_tmp5_);
	font_size = _tmp6_ / PANGO_SCALE;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp7_, NULL);
	xpad = _tmp7_;
	_tmp8_ = widget;
	_tmp9_ = *cell_area;
	_tmp10_ = flags;
	_tmp11_ = alm_files_cell_renderer_get_text (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = alm_files_cell_renderer_get_text_layout (self, _tmp8_, &_tmp9_, _tmp10_, _tmp12_, TRUE, font_size);
	_g_object_unref0 (text_layout);
	text_layout = _tmp13_;
	_tmp14_ = widget;
	_tmp15_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, _tmp14_, &_tmp15_, text_layout, &_tmp16_, &_tmp17_);
	text_x_offset = _tmp16_;
	text_y_offset = _tmp17_;
	pango_layout_get_pixel_extents (text_layout, NULL, &_tmp18_);
	text_rect = _tmp18_;
	_tmp19_ = text_x_offset;
	_tmp20_ = text_rect;
	_tmp21_ = _tmp20_.x;
	text_x_offset = _tmp19_ - _tmp21_;
	_tmp22_ = widget;
	_tmp23_ = *cell_area;
	_tmp24_ = flags;
	_tmp25_ = alm_files_cell_renderer_get_path (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = alm_files_cell_renderer_get_text_layout (self, _tmp22_, &_tmp23_, _tmp24_, _tmp26_, FALSE, font_size - 1);
	_g_object_unref0 (path_layout);
	path_layout = _tmp27_;
	_tmp28_ = widget;
	_tmp29_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, _tmp28_, &_tmp29_, path_layout, &_tmp30_, &_tmp31_);
	path_x_offset = _tmp30_;
	path_y_offset = _tmp31_;
	pango_layout_get_pixel_extents (path_layout, NULL, &_tmp32_);
	path_rect = _tmp32_;
	_tmp33_ = path_x_offset;
	_tmp34_ = path_rect;
	_tmp35_ = _tmp34_.x;
	path_x_offset = _tmp33_ - _tmp35_;
	_tmp36_ = cr;
	cairo_save (_tmp36_);
	_tmp37_ = cr;
	_tmp38_ = *cell_area;
	gdk_cairo_rectangle (_tmp37_, &_tmp38_);
	_tmp39_ = cr;
	cairo_clip (_tmp39_);
	_tmp40_ = cr;
	_tmp41_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = *cell_area;
	_tmp44_ = _tmp43_.x;
	_tmp45_ = *cell_area;
	_tmp46_ = _tmp45_.y;
	gdk_cairo_set_source_pixbuf (_tmp40_, _tmp42_, (gdouble) _tmp44_, (gdouble) _tmp46_);
	_tmp47_ = cr;
	cairo_paint (_tmp47_);
	_tmp48_ = cr;
	_tmp49_ = *cell_area;
	_tmp50_ = _tmp49_.x;
	_tmp51_ = text_x_offset;
	_tmp52_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = gdk_pixbuf_get_width (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = *cell_area;
	_tmp57_ = _tmp56_.y;
	_tmp58_ = text_y_offset;
	gtk_render_layout (context, _tmp48_, (gdouble) (((_tmp50_ + _tmp51_) + _tmp55_) + ALM_FILES_CELL_RENDERER_xspacing), (gdouble) ((_tmp57_ + _tmp58_) + 2), text_layout);
	_tmp59_ = cr;
	_tmp60_ = *cell_area;
	_tmp61_ = _tmp60_.x;
	_tmp62_ = path_x_offset;
	_tmp63_ = *cell_area;
	_tmp64_ = _tmp63_.y;
	_tmp65_ = path_y_offset;
	_tmp66_ = pango_layout_get_baseline (path_layout);
	gtk_render_layout (context, _tmp59_, (gdouble) (_tmp61_ + _tmp62_), (gdouble) ((((_tmp64_ + _tmp65_) + ALM_FILES_CELL_RENDERER_renderer_height) - 11) - (_tmp66_ / PANGO_SCALE)), path_layout);
	_tmp67_ = cr;
	cairo_restore (_tmp67_);
	_g_object_unref0 (path_layout);
	_g_object_unref0 (text_layout);
	_g_object_unref0 (context);
}


static void alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base, GtkWidget* widget, gint* min_width, gint* nat_width) {
	AlmFilesCellRenderer * self;
	gint _vala_min_width = 0;
	gint _vala_nat_width = 0;
	gint xpad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_vala_min_width = xpad + ALM_FILES_CELL_RENDERER_default_width;
	_vala_nat_width = _vala_min_width;
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (nat_width) {
		*nat_width = _vala_nat_width;
	}
}


static void alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base, GtkWidget* widget, gint width, gint* minimum_height, gint* natural_height) {
	AlmFilesCellRenderer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, NULL, &_tmp0_);
	ypad = _tmp0_;
	_vala_minimum_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	_vala_natural_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}


static void alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base, GtkWidget* widget, gint* minimum_size, gint* natural_size) {
	AlmFilesCellRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint min_width = 0;
	GtkWidget* _tmp0_;
	gint _tmp1_ = 0;
	GtkWidget* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, _tmp0_, &_tmp1_, NULL);
	min_width = _tmp1_;
	_tmp2_ = widget;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, _tmp2_, min_width, &_tmp3_, &_tmp4_);
	_vala_minimum_size = _tmp3_;
	_vala_natural_size = _tmp4_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}


GdkPixbuf* alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->pixbuf_);
	self->priv->pixbuf_ = _tmp1_;
	g_object_notify ((GObject *) self, "pixbuf");
}


const gchar* alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->text_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->text_);
	self->priv->text_ = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path_;
	result = _tmp0_;
	return result;
}


void alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->path_);
	self->priv->path_ = _tmp1_;
	g_object_notify ((GObject *) self, "path");
}


static void alm_files_cell_renderer_class_init (AlmFilesCellRendererClass * klass) {
	alm_files_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AlmFilesCellRendererPrivate));
	GTK_CELL_RENDERER_CLASS (klass)->get_size = alm_files_cell_renderer_real_get_size;
	GTK_CELL_RENDERER_CLASS (klass)->render = alm_files_cell_renderer_real_render;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_width = alm_files_cell_renderer_real_get_preferred_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height_for_width = alm_files_cell_renderer_real_get_preferred_height_for_width;
	GTK_CELL_RENDERER_CLASS (klass)->get_preferred_height = alm_files_cell_renderer_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_alm_files_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_alm_files_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = alm_files_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PIXBUF, g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void alm_files_cell_renderer_instance_init (AlmFilesCellRenderer * self) {
	self->priv = ALM_FILES_CELL_RENDERER_GET_PRIVATE (self);
}


static void alm_files_cell_renderer_finalize (GObject* obj) {
	AlmFilesCellRenderer * self;
	self = ALM_FILES_CELL_RENDERER (obj);
	_g_object_unref0 (self->priv->current_widget);
	_g_object_unref0 (self->priv->pixbuf_);
	_g_free0 (self->priv->text_);
	_g_free0 (self->priv->path_);
	G_OBJECT_CLASS (alm_files_cell_renderer_parent_class)->finalize (obj);
}


GType alm_files_cell_renderer_get_type (void) {
	static volatile gsize alm_files_cell_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&alm_files_cell_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AlmFilesCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_files_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFilesCellRenderer), 0, (GInstanceInitFunc) alm_files_cell_renderer_instance_init, NULL };
		GType alm_files_cell_renderer_type_id;
		alm_files_cell_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER, "AlmFilesCellRenderer", &g_define_type_info, 0);
		g_once_init_leave (&alm_files_cell_renderer_type_id__volatile, alm_files_cell_renderer_type_id);
	}
	return alm_files_cell_renderer_type_id__volatile;
}


static void _vala_alm_files_cell_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AlmFilesCellRenderer * self;
	self = ALM_FILES_CELL_RENDERER (object);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF:
		g_value_set_object (value, alm_files_cell_renderer_get_pixbuf (self));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT:
		g_value_set_string (value, alm_files_cell_renderer_get_text (self));
		break;
		case ALM_FILES_CELL_RENDERER_PATH:
		g_value_set_string (value, alm_files_cell_renderer_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_alm_files_cell_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AlmFilesCellRenderer * self;
	self = ALM_FILES_CELL_RENDERER (object);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF:
		alm_files_cell_renderer_set_pixbuf (self, g_value_get_object (value));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT:
		alm_files_cell_renderer_set_text (self, g_value_get_string (value));
		break;
		case ALM_FILES_CELL_RENDERER_PATH:
		alm_files_cell_renderer_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



